/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jna;

import com.sun.jna.Native;
import org.elasticsearch.common.jna.CLibrary;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class Natives {
    private static ESLogger logger = Loggers.getLogger(Natives.class);

    public static void tryMlockall() {
        int errno = Integer.MIN_VALUE;
        try {
            int result = CLibrary.mlockall(1);
            if (result != 0) {
                errno = Native.getLastError();
            }
        }
        catch (UnsatisfiedLinkError e) {
            return;
        }
        if (errno != Integer.MIN_VALUE) {
            if (errno == 12 && System.getProperty("os.name").toLowerCase().contains("linux")) {
                logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out. Increase RLIMIT_MEMLOCK or run elasticsearch as root.", new Object[0]);
            } else if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
                logger.warn("Unknown mlockall error " + errno, new Object[0]);
            }
        }
    }
}

