/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.shards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.local.state.shards.LocalGatewayShardsState;
import org.elasticsearch.gateway.local.state.shards.ShardStateInfo;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayStartedShards
extends TransportNodesOperationAction<Request, NodesLocalGatewayStartedShards, NodeRequest, NodeLocalGatewayStartedShards> {
    private LocalGatewayShardsState shardsState;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
    }

    TransportNodesListGatewayStartedShards initGateway(LocalGatewayShardsState shardsState) {
        this.shardsState = shardsState;
        return this;
    }

    public ActionFuture<NodesLocalGatewayStartedShards> list(ShardId shardId, Set<String> nodesIds, @Nullable TimeValue timeout) {
        return this.execute(new Request(shardId, nodesIds).timeout(timeout));
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "/gateway/local/started-shards";
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected Request newRequest() {
        return new Request();
    }

    @Override
    protected NodeRequest newNodeRequest() {
        return new NodeRequest();
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeLocalGatewayStartedShards newNodeResponse() {
        return new NodeLocalGatewayStartedShards();
    }

    @Override
    protected NodesLocalGatewayStartedShards newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeLocalGatewayStartedShards> nodesList = Lists.newArrayList();
        ArrayList<FailedNodeException> failures = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeLocalGatewayStartedShards) {
                nodesList.add((NodeLocalGatewayStartedShards)resp);
                continue;
            }
            if (!(resp instanceof FailedNodeException)) continue;
            failures.add((FailedNodeException)resp);
        }
        return new NodesLocalGatewayStartedShards(this.clusterName, nodesList.toArray(new NodeLocalGatewayStartedShards[nodesList.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeLocalGatewayStartedShards nodeOperation(NodeRequest request) throws ElasticSearchException {
        try {
            ShardStateInfo shardStateInfo = this.shardsState.loadShardInfo(request.shardId);
            if (shardStateInfo != null) {
                return new NodeLocalGatewayStartedShards(this.clusterService.localNode(), shardStateInfo.version);
            }
            return new NodeLocalGatewayStartedShards(this.clusterService.localNode(), -1L);
        }
        catch (Exception e) {
            throw new ElasticSearchException("failed to load started shards", e);
        }
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeLocalGatewayStartedShards
    extends NodeOperationResponse {
        private long version = -1L;

        NodeLocalGatewayStartedShards() {
        }

        public NodeLocalGatewayStartedShards(DiscoveryNode node, long version) {
            super(node);
            this.version = version;
        }

        public boolean hasVersion() {
            return this.version != -1L;
        }

        public long version() {
            return this.version;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.version = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.version);
        }
    }

    static class NodeRequest
    extends NodeOperationRequest {
        ShardId shardId;

        NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(request, nodeId);
            this.shardId = request.shardId();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }

    public static class NodesLocalGatewayStartedShards
    extends NodesOperationResponse<NodeLocalGatewayStartedShards> {
        private FailedNodeException[] failures;

        NodesLocalGatewayStartedShards() {
        }

        public NodesLocalGatewayStartedShards(ClusterName clusterName, NodeLocalGatewayStartedShards[] nodes, FailedNodeException[] failures) {
            super(clusterName, (NodeOperationResponse[])nodes);
            this.failures = failures;
        }

        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeLocalGatewayStartedShards[in.readVInt()];
            for (int i = 0; i < ((NodeLocalGatewayStartedShards[])this.nodes).length; ++i) {
                ((NodeLocalGatewayStartedShards[])this.nodes)[i] = new NodeLocalGatewayStartedShards();
                ((NodeLocalGatewayStartedShards[])this.nodes)[i].readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeLocalGatewayStartedShards[])this.nodes).length);
            for (NodeLocalGatewayStartedShards response : (NodeLocalGatewayStartedShards[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    static class Request
    extends NodesOperationRequest<Request> {
        private ShardId shardId;

        public Request() {
        }

        public Request(ShardId shardId, Set<String> nodesIds) {
            super(nodesIds.toArray(new String[nodesIds.size()]));
            this.shardId = shardId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }
}

