/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.GeoDistanceRangeFilter;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.search.geo.GeoUtils;
import org.elasticsearch.index.search.geo.Point;

public class GeoDistanceRangeFilterParser
implements FilterParser {
    public static final String NAME = "geo_distance_range";

    @Inject
    public GeoDistanceRangeFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoDistanceRange"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        MapperService.SmartNameFieldMappers smartMappers;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        double lat = 0.0;
        double lon = 0.0;
        String fieldName = null;
        Object vFrom = null;
        Object vTo = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        DistanceUnit unit = DistanceUnit.KILOMETERS;
        GeoDistance geoDistance = GeoDistance.ARC;
        String optimizeBbox = "memory";
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                token = parser.nextToken();
                lon = parser.doubleValue();
                token = parser.nextToken();
                lat = parser.doubleValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                fieldName = currentFieldName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String currentName = parser.currentName();
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        lat = parser.doubleValue();
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        lon = parser.doubleValue();
                        continue;
                    }
                    if (!currentName.equals("geohash")) continue;
                    double[] values = GeoHashUtils.decode(parser.text());
                    lat = values[0];
                    lon = values[1];
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (currentFieldName.equals("from")) {
                if (token == XContentParser.Token.VALUE_NULL) continue;
                if (token == XContentParser.Token.VALUE_STRING) {
                    vFrom = parser.text();
                    continue;
                }
                vFrom = parser.numberValue();
                continue;
            }
            if (currentFieldName.equals("to")) {
                if (token == XContentParser.Token.VALUE_NULL) continue;
                if (token == XContentParser.Token.VALUE_STRING) {
                    vTo = parser.text();
                    continue;
                }
                vTo = parser.numberValue();
                continue;
            }
            if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                includeLower = parser.booleanValue();
                continue;
            }
            if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                includeUpper = parser.booleanValue();
                continue;
            }
            if ("gt".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vFrom = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = false;
                continue;
            }
            if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vFrom = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = true;
                continue;
            }
            if ("lt".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vTo = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = false;
                continue;
            }
            if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vTo = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = true;
                continue;
            }
            if (currentFieldName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentFieldName.equals("distance_type") || currentFieldName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                lat = parser.doubleValue();
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                lon = parser.doubleValue();
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (currentFieldName.endsWith(".geohash")) {
                double[] values = GeoHashUtils.decode(parser.text());
                lat = values[0];
                lon = values[1];
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".geohash".length());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            if ("optimize_bbox".equals(currentFieldName) || "optimizeBbox".equals(currentFieldName)) {
                optimizeBbox = parser.textOrNull();
                continue;
            }
            if ("normalize".equals(currentFieldName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            String value = parser.text();
            int comma = value.indexOf(44);
            if (comma != -1) {
                lat = Double.parseDouble(value.substring(0, comma).trim());
                lon = Double.parseDouble(value.substring(comma + 1).trim());
            } else {
                double[] values = GeoHashUtils.decode(value);
                lat = values[0];
                lon = values[1];
            }
            fieldName = currentFieldName;
        }
        Double from = null;
        Double to = null;
        if (vFrom != null) {
            from = vFrom instanceof Number ? Double.valueOf(unit.toMiles(((Number)vFrom).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)vFrom, unit, DistanceUnit.MILES));
            from = geoDistance.normalize(from, DistanceUnit.MILES);
        }
        if (vTo != null) {
            to = vTo instanceof Number ? Double.valueOf(unit.toMiles(((Number)vTo).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)vTo, unit, DistanceUnit.MILES));
            to = geoDistance.normalize(to, DistanceUnit.MILES);
        }
        if (normalizeLat || normalizeLon) {
            Point point = new Point(lat, lon);
            GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
            lat = point.lat;
            lon = point.lon;
        }
        if ((smartMappers = parseContext.smartFieldMappers(fieldName)) == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.mapper();
        if (mapper.fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        GeoPointFieldMapper geoMapper = ((GeoPointFieldMapper.GeoStringFieldMapper)mapper).geoMapper();
        fieldName = mapper.names().indexName();
        Filter filter = new GeoDistanceRangeFilter(lat, lon, from, to, includeLower, includeUpper, geoDistance, fieldName, geoMapper, parseContext.indexCache().fieldData(), optimizeBbox);
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

