/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class OsStats
implements Streamable,
Serializable,
ToXContent {
    public static final double[] EMPTY_LOAD = new double[0];
    long timestamp;
    double[] loadAverage = EMPTY_LOAD;
    long uptime = -1L;
    Cpu cpu = null;
    Mem mem = null;
    Swap swap = null;

    OsStats() {
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp();
    }

    public double[] loadAverage() {
        return this.loadAverage;
    }

    public double[] getLoadAverage() {
        return this.loadAverage();
    }

    public TimeValue uptime() {
        return new TimeValue(this.uptime, TimeUnit.SECONDS);
    }

    public TimeValue getUptime() {
        return this.uptime();
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public Cpu getCpu() {
        return this.cpu();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Swap swap() {
        return this.swap;
    }

    public Swap getSwap() {
        return this.swap();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.OS);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        if (this.uptime != -1L) {
            builder.field(Fields.UPTIME, this.uptime().format());
            builder.field(Fields.UPTIME_IN_MILLIS, this.uptime().millis());
        }
        if (this.loadAverage.length > 0) {
            builder.startArray(Fields.LOAD_AVERAGE);
            for (double value : this.loadAverage) {
                builder.value(value);
            }
            builder.endArray();
        }
        if (this.cpu != null) {
            builder.startObject(Fields.CPU);
            builder.field(Fields.SYS, (int)this.cpu.sys());
            builder.field(Fields.USER, (int)this.cpu.user());
            builder.field(Fields.IDLE, (int)this.cpu.idle());
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.field(Fields.FREE, this.mem.free().toString());
            builder.field(Fields.FREE_IN_BYTES, this.mem.free);
            builder.field(Fields.USED, this.mem.used().toString());
            builder.field(Fields.USED_IN_BYTES, this.mem.used);
            builder.field(Fields.FREE_PERCENT, (int)this.mem.freePercent());
            builder.field(Fields.USED_PERCENT, (int)this.mem.usedPercent());
            builder.field(Fields.ACTUAL_FREE, this.mem.actualFree().toString());
            builder.field(Fields.ACTUAL_FREE_IN_BYTES, this.mem.actualFree);
            builder.field(Fields.ACTUAL_USED, this.mem.actualUsed().toString());
            builder.field(Fields.ACTUAL_USED_IN_BYTES, this.mem.actualUsed);
            builder.endObject();
        }
        if (this.swap != null) {
            builder.startObject(Fields.SWAP);
            builder.field(Fields.USED, this.swap.used().toString());
            builder.field(Fields.USED_IN_BYTES, this.swap.used);
            builder.field(Fields.FREE, this.swap.free().toString());
            builder.field(Fields.FREE_IN_BYTES, this.swap.free);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static OsStats readOsStats(StreamInput in) throws IOException {
        OsStats stats = new OsStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.loadAverage = new double[in.readVInt()];
        for (int i = 0; i < this.loadAverage.length; ++i) {
            this.loadAverage[i] = in.readDouble();
        }
        this.uptime = in.readLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
        if (in.readBoolean()) {
            this.swap = Swap.readSwap(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVInt(this.loadAverage.length);
        for (double val : this.loadAverage) {
            out.writeDouble(val);
        }
        out.writeLong(this.uptime);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
        if (this.swap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.swap.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable,
    Serializable {
        short sys = (short)-1;
        short user = (short)-1;
        short idle = (short)-1;

        Cpu() {
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.sys = in.readShort();
            this.user = in.readShort();
            this.idle = in.readShort();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.sys);
            out.writeShort(this.user);
            out.writeShort(this.idle);
        }

        public short sys() {
            return this.sys;
        }

        public short getSys() {
            return this.sys();
        }

        public short user() {
            return this.user;
        }

        public short getUser() {
            return this.user();
        }

        public short idle() {
            return this.idle;
        }

        public short getIdle() {
            return this.idle();
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long free = -1L;
        short freePercent = (short)-1;
        long used = -1L;
        short usedPercent = (short)-1;
        long actualFree = -1L;
        long actualUsed = -1L;

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.free = in.readLong();
            this.freePercent = in.readShort();
            this.used = in.readLong();
            this.usedPercent = in.readShort();
            this.actualFree = in.readLong();
            this.actualUsed = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.free);
            out.writeShort(this.freePercent);
            out.writeLong(this.used);
            out.writeShort(this.usedPercent);
            out.writeLong(this.actualFree);
            out.writeLong(this.actualUsed);
        }

        public ByteSizeValue used() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getUsed() {
            return this.used();
        }

        public short usedPercent() {
            return this.usedPercent;
        }

        public short getUsedPercent() {
            return this.usedPercent();
        }

        public ByteSizeValue free() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getFree() {
            return this.free();
        }

        public short freePercent() {
            return this.freePercent;
        }

        public short getFreePercent() {
            return this.freePercent();
        }

        public ByteSizeValue actualFree() {
            return new ByteSizeValue(this.actualFree);
        }

        public ByteSizeValue getActualFree() {
            return this.actualFree();
        }

        public ByteSizeValue actualUsed() {
            return new ByteSizeValue(this.actualUsed);
        }

        public ByteSizeValue getActualUsed() {
            return this.actualUsed();
        }
    }

    public static class Swap
    implements Streamable,
    Serializable {
        long free = -1L;
        long used = -1L;

        public ByteSizeValue free() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getFree() {
            return this.free();
        }

        public ByteSizeValue used() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getUsed() {
            return this.used();
        }

        public static Swap readSwap(StreamInput in) throws IOException {
            Swap swap = new Swap();
            swap.readFrom(in);
            return swap;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.free = in.readLong();
            this.used = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.free);
            out.writeLong(this.used);
        }
    }

    static final class Fields {
        static final XContentBuilderString OS = new XContentBuilderString("os");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString UPTIME = new XContentBuilderString("uptime");
        static final XContentBuilderString UPTIME_IN_MILLIS = new XContentBuilderString("uptime_in_millis");
        static final XContentBuilderString LOAD_AVERAGE = new XContentBuilderString("load_average");
        static final XContentBuilderString CPU = new XContentBuilderString("cpu");
        static final XContentBuilderString SYS = new XContentBuilderString("sys");
        static final XContentBuilderString USER = new XContentBuilderString("user");
        static final XContentBuilderString IDLE = new XContentBuilderString("idle");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString SWAP = new XContentBuilderString("swap");
        static final XContentBuilderString FREE = new XContentBuilderString("free");
        static final XContentBuilderString FREE_IN_BYTES = new XContentBuilderString("free_in_bytes");
        static final XContentBuilderString USED = new XContentBuilderString("used");
        static final XContentBuilderString USED_IN_BYTES = new XContentBuilderString("used_in_bytes");
        static final XContentBuilderString FREE_PERCENT = new XContentBuilderString("free_percent");
        static final XContentBuilderString USED_PERCENT = new XContentBuilderString("used_percent");
        static final XContentBuilderString ACTUAL_FREE = new XContentBuilderString("actual_free");
        static final XContentBuilderString ACTUAL_FREE_IN_BYTES = new XContentBuilderString("actual_free_in_bytes");
        static final XContentBuilderString ACTUAL_USED = new XContentBuilderString("actual_used");
        static final XContentBuilderString ACTUAL_USED_IN_BYTES = new XContentBuilderString("actual_used_in_bytes");

        Fields() {
        }
    }
}

