/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.exists.types;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.action.support.RestActions;

public class RestTypesExistsAction
extends BaseRestHandler {
    @Inject
    public RestTypesExistsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}", this);
    }

    @Override
    public void handleRequest(RestRequest request, final RestChannel channel) {
        TypesExistsRequest typesExistsRequest = new TypesExistsRequest(RestActions.splitIndices(request.param("index")), RestActions.splitTypes(request.param("type")));
        typesExistsRequest.listenerThreaded(false);
        if (request.hasParam("ignore_indices")) {
            typesExistsRequest.ignoreIndices(IgnoreIndices.fromString(request.param("ignore_indices")));
        }
        this.client.admin().indices().typesExists(typesExistsRequest, new ActionListener<TypesExistsResponse>(){

            @Override
            public void onResponse(TypesExistsResponse response) {
                try {
                    if (response.exists()) {
                        channel.sendResponse(new StringRestResponse(RestStatus.OK));
                    } else {
                        channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new StringRestResponse(ExceptionsHelper.status(e)));
                }
                catch (Exception e1) {
                    RestTypesExistsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

