/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.utils;

import io.fabric8.utils.Closeables;
import io.fabric8.zookeeper.utils.RegexSupport;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;

public class ZookeeperImportUtils {
    private ZookeeperImportUtils() {
    }

    public static void importFromFileSystem(CuratorFramework curator, String source, String target, String[] includeRegex, String[] excludeRegex, boolean delete, boolean dryRun, boolean verbose) throws Exception {
        TreeMap<String, String> settings = new TreeMap<String, String>();
        File s = new File(source);
        ZookeeperImportUtils.getCandidates(s, s, settings, target);
        List<Pattern> include = RegexSupport.getPatterns(includeRegex);
        List<Pattern> exclude = RegexSupport.getPatterns(excludeRegex);
        if (!target.startsWith("/")) {
            target = "/" + target;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (Map.Entry entry : settings.entrySet()) {
            String key = (String)entry.getKey();
            String data = (String)entry.getValue();
            key = target + key;
            paths.add(key);
            if (!RegexSupport.matches(include, key, true) || RegexSupport.matches(exclude, key, false)) continue;
            if (!dryRun) {
                if (data == null) continue;
                if (verbose) {
                    System.out.println("importing: " + key);
                }
                ZooKeeperUtils.setData(curator, key, data);
                continue;
            }
            System.out.printf("Creating path \"%s\" with value \"%s\"\n", key, data);
        }
        if (delete) {
            ZookeeperImportUtils.deletePathsNotIn(curator, paths, target, dryRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFromPropertiesFile(CuratorFramework curator, String source, String target, String[] includeRegex, String[] excludeRegex, boolean dryRun) throws Exception {
        List<Pattern> includes = RegexSupport.getPatterns(includeRegex);
        List<Pattern> excludes = RegexSupport.getPatterns(excludeRegex);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new URL(source).openStream());
            Properties props = new Properties();
            props.load(in);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                if (value != null && value.isEmpty()) {
                    value = null;
                }
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                if (!RegexSupport.matches(includes, name = target + name, true) || RegexSupport.matches(excludes, name, false)) continue;
                if (!dryRun) {
                    ZooKeeperUtils.setData(curator, name, value);
                    continue;
                }
                System.out.printf("Creating path \"%s\" with value \"%s\"\n", name, value);
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuitely(in);
            throw throwable;
        }
        Closeables.closeQuitely(in);
    }

    private static void getCandidates(File parent, File current, Map<String, String> settings, String target) throws Exception {
        if (current.isDirectory()) {
            for (File child : current.listFiles()) {
                ZookeeperImportUtils.getCandidates(parent, child, settings, target);
            }
            String p = ZookeeperImportUtils.buildZKPath(parent, current).replaceFirst("/", "");
            settings.put(p, null);
        } else {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(current));
            byte[] contents = new byte[in.available()];
            in.read(contents);
            in.close();
            String p = ZookeeperImportUtils.buildZKPath(parent, current).replaceFirst("/", "");
            if (p.endsWith(".cfg")) {
                p = p.substring(0, p.length() - ".cfg".length());
            }
            settings.put(p, new String(contents));
        }
    }

    private static String buildZKPath(File parent, File current) {
        String rc = "";
        if (current != null && !parent.equals(current)) {
            rc = ZookeeperImportUtils.buildZKPath(parent, current.getParentFile()) + "/" + current.getName();
        }
        return rc;
    }

    private static void deletePathsNotIn(CuratorFramework curator, List<String> paths, String target, boolean dryRun) throws Exception {
        List zkPaths = (List)curator.getChildren().forPath(target);
        for (String path : zkPaths) {
            path = "/" + path;
            if (paths.contains(path)) continue;
            if (!dryRun) {
                curator.delete().guaranteed().forPath(path);
                continue;
            }
            System.out.printf("Deleting path %s and everything under it\n", path);
        }
    }
}

