/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.curator.framework.recipes.locks.LockInternals;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import org.apache.curator.framework.recipes.shared.SharedCountListener;
import org.apache.curator.framework.recipes.shared.SharedCountReader;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessSemaphore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LockInternals internals;
    private static final String LOCK_NAME = "lock-";

    public InterProcessSemaphore(CuratorFramework client, String path, int maxLeases) {
        this(client, path, maxLeases, null);
    }

    public InterProcessSemaphore(CuratorFramework client, String path, SharedCountReader count) {
        this(client, path, 0, count);
    }

    private InterProcessSemaphore(CuratorFramework client, String path, int maxLeases, SharedCountReader count) {
        this.internals = new LockInternals(client, new StandardLockInternalsDriver(), path, LOCK_NAME, count != null ? count.getCount() : maxLeases);
        if (count != null) {
            count.addListener(new SharedCountListener(){

                @Override
                public void countHasChanged(SharedCountReader sharedCount, int newCount) throws Exception {
                    InterProcessSemaphore.this.internals.setMaxLeases(newCount);
                }

                @Override
                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                }
            });
        }
    }

    public void returnAll(Collection<Lease> leases) {
        for (Lease l : leases) {
            Closeables.closeQuietly((Closeable)l);
        }
    }

    public void returnLease(Lease lease) {
        Closeables.closeQuietly((Closeable)lease);
    }

    public Lease acquire() throws Exception {
        String path = this.internals.attemptLock(-1L, null, null);
        return this.makeLease(path);
    }

    public Collection<Lease> acquire(int qty) throws Exception {
        Preconditions.checkArgument((qty > 0 ? 1 : 0) != 0, (Object)"qty cannot be 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            while (qty-- > 0) {
                String path = this.internals.attemptLock(-1L, null, null);
                builder.add((Object)this.makeLease(path));
            }
        }
        catch (Exception e) {
            this.returnAll((Collection<Lease>)builder.build());
            throw e;
        }
        return builder.build();
    }

    public Lease acquire(long time, TimeUnit unit) throws Exception {
        String path = this.internals.attemptLock(time, unit, null);
        return path != null ? this.makeLease(path) : null;
    }

    public Collection<Lease> acquire(int qty, long time, TimeUnit unit) throws Exception {
        long startMs = System.currentTimeMillis();
        long waitMs = TimeUnit.MILLISECONDS.convert(time, unit);
        Preconditions.checkArgument((qty > 0 ? 1 : 0) != 0, (Object)"qty cannot be 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            while (qty-- > 0) {
                String path;
                long elapsedMs = System.currentTimeMillis() - startMs;
                long thisWaitMs = waitMs - elapsedMs;
                String string = path = thisWaitMs > 0L ? this.internals.attemptLock(thisWaitMs, TimeUnit.MILLISECONDS, null) : null;
                if (path == null) {
                    this.returnAll((Collection<Lease>)builder.build());
                    return null;
                }
                builder.add((Object)this.makeLease(path));
            }
        }
        catch (Exception e) {
            this.returnAll((Collection<Lease>)builder.build());
            throw e;
        }
        return builder.build();
    }

    private Lease makeLease(final String path) {
        return new Lease(){

            @Override
            public void close() throws IOException {
                try {
                    InterProcessSemaphore.this.internals.releaseLock(path);
                }
                catch (KeeperException.NoNodeException e) {
                    InterProcessSemaphore.this.log.warn("Lease already released", (Throwable)e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            @Override
            public byte[] getData() throws Exception {
                return (byte[])InterProcessSemaphore.this.internals.getClient().getData().forPath(path);
            }
        };
    }
}

