/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.DynamicReferenceException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicReference<T>
implements Callable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicReference.class);
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final String DEFAULT_NAME = "dynamic reference";
    private static final String TIMEOUT_MESSAGE_FORMAT = "Gave up waiting for: %s";
    private final AtomicReference<ValueRevision> revision = new AtomicReference();
    private final long timeout;
    private final TimeUnit unit;
    private final String name;

    public DynamicReference() {
        this(DEFAULT_NAME);
    }

    public DynamicReference(String name) {
        this(name, 5000L, TimeUnit.MILLISECONDS);
    }

    public DynamicReference(String name, long timeout, TimeUnit unit) {
        this.name = name;
        this.unit = unit;
        this.timeout = timeout;
        this.revision.set(new ValueRevision());
    }

    @Override
    public T call() throws Exception {
        return this.callInternal();
    }

    public T get() {
        try {
            return this.callInternal();
        }
        catch (TimeoutException ex) {
            throw new DynamicReferenceException(String.format(TIMEOUT_MESSAGE_FORMAT, this.name));
        }
    }

    private T callInternal() throws TimeoutException {
        long start = System.currentTimeMillis();
        Object value = this.currentRevision().call(this.timeout, this.unit);
        while (value == null) {
            LOG.warn("Unbound while waiting for: {}", (Object)this.name);
            long elapsed = System.currentTimeMillis() - start;
            long remaining = this.unit.toMillis(this.timeout) - elapsed;
            if (remaining <= 0L) {
                throw new TimeoutException(String.format(TIMEOUT_MESSAGE_FORMAT, this.name));
            }
            value = this.currentRevision().call(remaining, TimeUnit.MILLISECONDS);
        }
        return value;
    }

    public T getIfPresent() {
        return this.currentRevision().getIfPresent();
    }

    public void bind(T value) {
        this.currentRevision().bind(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(T value) {
        AtomicReference<ValueRevision> atomicReference = this.revision;
        synchronized (atomicReference) {
            ValueRevision currev = this.revision.get();
            currev.unbind(value);
            if (currev.getIfPresent() == null) {
                this.revision.set(new ValueRevision());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueRevision currentRevision() {
        AtomicReference<ValueRevision> atomicReference = this.revision;
        synchronized (atomicReference) {
            return this.revision.get();
        }
    }

    class ValueRevision {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<T> ref = new AtomicReference();

        ValueRevision() {
        }

        void bind(T value) {
            if (value == null) {
                throw new IllegalArgumentException("Null value");
            }
            LOG.debug("bind: {}", value);
            this.ref.set(value);
            this.latch.countDown();
        }

        void unbind(T value) {
            if (value == null) {
                throw new IllegalArgumentException("Null value");
            }
            LOG.debug("unbind: {}", value);
            this.ref.compareAndSet(value, null);
            this.latch.countDown();
        }

        T getIfPresent() {
            return this.ref.get();
        }

        T call(long timeout, TimeUnit unit) throws TimeoutException {
            try {
                if (!this.latch.await(timeout, unit)) {
                    throw new TimeoutException(String.format(DynamicReference.TIMEOUT_MESSAGE_FORMAT, DynamicReference.this.name));
                }
                return this.ref.get();
            }
            catch (InterruptedException ex) {
                return null;
            }
        }
    }
}

