/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.MasterComponent;
import io.fabric8.camel.MasterConsumer;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private static final transient Log LOG = LogFactory.getLog(MasterEndpoint.class);
    private final MasterComponent component;
    private final String singletonId;
    private final String child;
    private final Endpoint childEndpoint;

    public MasterEndpoint(String uri, MasterComponent component, String singletonId, String child) {
        super(uri, (Component)component);
        this.component = component;
        this.singletonId = singletonId;
        this.child = child;
        this.childEndpoint = this.getCamelContext().getEndpoint(child);
    }

    public String getSingletonId() {
        return this.singletonId;
    }

    public Producer createProducer() throws Exception {
        return this.getChildEndpoint().createProducer();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new MasterConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public MasterComponent getComponent() {
        return this.component;
    }

    public String getChild() {
        return this.child;
    }

    Endpoint getChildEndpoint() {
        return this.childEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.getChildEndpoint();
    }
}

