/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.fab.Content;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DirectoryContent
implements Content {
    final File directory;
    final URI root;
    List<String> entries;

    public DirectoryContent(String directory) {
        this.directory = new File(directory);
        this.root = this.directory.toURI();
    }

    @Override
    public Iterable<String> getEntries() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    LinkedList<File> files;
                    {
                        this.files = new LinkedList<File>(Collections.singletonList(DirectoryContent.this.directory));
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.files.isEmpty();
                    }

                    @Override
                    public String next() {
                        File[] children;
                        File file = this.files.removeFirst();
                        if (file.isDirectory() && (children = file.listFiles()) != null) {
                            for (File f : children) {
                                this.files.add(f);
                            }
                        }
                        return DirectoryContent.this.root.relativize(file.toURI()).toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public URL getURL(String entry) throws MalformedURLException {
        File f = new File(this.directory, entry);
        if (f.exists()) {
            return f.toURI().toURL();
        }
        return null;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "DirectoryContent[" + this.directory + ']';
    }
}

