/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.fab.DependencyId;
import io.fabric8.fab.ModuleDescriptor;
import io.fabric8.fab.VersionedDependencyId;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class ModuleRegistry {
    private HashMap<DependencyId, Module> modules = new HashMap();
    private HashMap<VersionedDependencyId, VersionedModule> moduleVersions = new HashMap();
    private HashMap<VersionedDependencyId, TreeMap<String, VersionedModule>> extensions = new HashMap();
    private HashMap<VersionedDependencyId, List<String>> enabledExtensions = new HashMap();

    public VersionedModule add(ModuleDescriptor descriptor) {
        return this.add(descriptor, null);
    }

    public void clear() {
        this.modules.clear();
        this.moduleVersions.clear();
    }

    protected VersionedModule add(ModuleDescriptor descriptor, File file) {
        VersionedDependencyId id = descriptor.getId();
        this.remove(id);
        VersionedModule rc = new VersionedModule(descriptor, file);
        this.moduleVersions.put(id, rc);
        DependencyId dependencyId = id.toDependencyId();
        Module module = this.modules.get(dependencyId);
        if (module == null) {
            module = new Module(dependencyId);
            this.modules.put(dependencyId, module);
        }
        module.versions.put(id.getVersion(), rc);
        for (VersionedDependencyId key : descriptor.getExtendsModules()) {
            TreeMap<String, VersionedModule> map = this.extensions.get(key);
            if (map == null) {
                map = new TreeMap();
                this.extensions.put(key, map);
            }
            map.put(rc.getName(), rc);
        }
        return rc;
    }

    public VersionedModule remove(VersionedDependencyId id) {
        VersionedModule versionedModule = this.moduleVersions.remove(id);
        if (versionedModule != null) {
            ModuleDescriptor descriptor = versionedModule.descriptor;
            for (VersionedDependencyId key : descriptor.getExtendsModules()) {
                TreeMap<String, VersionedModule> map = this.extensions.get(key);
                if (map == null) continue;
                map.remove(versionedModule.getName());
                if (!map.isEmpty()) continue;
                this.extensions.remove(key);
            }
            DependencyId dependencyId = id.toDependencyId();
            Module module = this.modules.get(dependencyId);
            if (module != null) {
                module.versions.remove(id.getVersion());
                if (module.versions.isEmpty()) {
                    this.modules.remove(dependencyId);
                }
            }
        }
        return versionedModule;
    }

    protected List<String> getEnabledExtensions(VersionedDependencyId id) {
        return this.enabledExtensions.get(id);
    }

    protected void setEnabledExtensions(VersionedDependencyId id, List<String> values) {
        if (values == null) {
            this.enabledExtensions.remove(id);
        } else {
            this.enabledExtensions.put(id, values);
        }
    }

    public VersionedModule getVersionedModule(VersionedDependencyId id) {
        return this.moduleVersions.get(id);
    }

    public List<Module> getModules() {
        ArrayList<Module> rc = new ArrayList<Module>(this.modules.values());
        Collections.sort(rc, new Comparator<Module>(){

            @Override
            public int compare(Module d1, Module d2) {
                return d1.getName().compareTo(d2.getName());
            }
        });
        return rc;
    }

    public List<Module> getApplicationModules() {
        List<Module> rc = this.getModules();
        Iterator<Module> iterator = rc.iterator();
        while (iterator.hasNext()) {
            Module next = iterator.next();
            if (!next.latest().isExtensionModule()) continue;
            iterator.remove();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJar(File file) throws IOException {
        JarInputStream jar = new JarInputStream(new FileInputStream(file));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = jar.getNextEntry()) != null) {
                if (zipEntry.getName().endsWith(".fmd") && !zipEntry.isDirectory()) {
                    this.load(null, jar);
                }
                jar.closeEntry();
            }
        }
        finally {
            jar.close();
        }
    }

    public void loadDirectory(File directory, PrintStream err) {
        this.loadDirectory(directory, err, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDirectory(File directory, PrintStream err, boolean local) {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                this.loadDirectory(f, err, local);
                continue;
            }
            if (!f.getName().endsWith(".fmd")) continue;
            try {
                FileInputStream is = new FileInputStream(f);
                try {
                    this.load(local ? f : null, is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                err.println("Error loading fab module descriptor '" + f + "': " + e);
            }
        }
    }

    private void load(File f, InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        ModuleDescriptor descriptor = ModuleDescriptor.fromProperties(properties);
        if (this.getVersionedModule(descriptor.getId()) == null) {
            this.add(descriptor, f);
        }
    }

    public class Module {
        final DependencyId id;
        final TreeMap<String, VersionedModule> versions;

        Module(DependencyId id) {
            this.id = id;
            this.versions = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String d1, String d2) {
                    return d1.compareTo(d2);
                }
            });
        }

        public VersionedModule latest() {
            return this.versions.lastEntry().getValue();
        }

        public String getName() {
            if (this.latest().getName() != null) {
                return this.latest().getName();
            }
            return this.latest().getId().getArtifactId();
        }

        public Map<String, VersionedModule> getVersions() {
            return Collections.unmodifiableMap(this.versions);
        }

        public List<VersionedDependencyId> getVersionIds() {
            ArrayList<VersionedDependencyId> rc = new ArrayList<VersionedDependencyId>(this.versions.size());
            for (VersionedModule module : this.versions.values()) {
                rc.add(module.getId());
            }
            return rc;
        }
    }

    public class VersionedModule {
        private final ModuleDescriptor descriptor;
        private final File file;

        VersionedModule(ModuleDescriptor descriptor, File file) {
            this.descriptor = descriptor;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public Map<String, VersionedModule> getAvailableExtensions() {
            TreeMap map = (TreeMap)ModuleRegistry.this.extensions.get(this.descriptor.getId());
            if (map == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(map);
        }

        public List<String> getEnabledExtensions() {
            List<String> rc = ModuleRegistry.this.getEnabledExtensions(this.descriptor.getId());
            if (rc == null) {
                return Collections.unmodifiableList(this.getDefaultExtensions());
            }
            return Collections.unmodifiableList(rc);
        }

        public void setEnabledExtensions(List<String> extensions) {
            ModuleRegistry.this.setEnabledExtensions(this.descriptor.getId(), extensions);
        }

        public List<String> getDefaultExtensions() {
            return Collections.unmodifiableList(this.descriptor.getDefaultExtensions());
        }

        public VersionedDependencyId getId() {
            return this.descriptor.getId();
        }

        public String getLongDescription() {
            return this.descriptor.getLongDescription();
        }

        public String getName() {
            return this.descriptor.getName();
        }

        public String getDescription() {
            return this.descriptor.getDescription();
        }

        public boolean isExtensionModule() {
            return this.descriptor.isExtensionModule();
        }
    }
}

