/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.commands;

import io.fabric8.fab.osgi.FabBundleInfo;
import io.fabric8.fab.osgi.FabResolver;
import io.fabric8.fab.osgi.FabResolverFactory;
import io.fabric8.fab.osgi.internal.BundleFabFacade;
import io.fabric8.fab.osgi.internal.FabClassPathResolver;
import io.fabric8.fab.osgi.internal.FabResolverFactoryImpl;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.sonatype.aether.RepositoryException;

public abstract class CommandSupport
extends OsgiCommandSupport {
    private PackageAdmin admin;
    private FabResolverFactory factory;
    private OsgiModuleRegistry registry;

    protected PackageAdmin getPackageAdmin() {
        if (this.admin == null) {
            ServiceReference ref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
            if (ref == null) {
                System.out.println("PackageAdmin service is unavailable.");
                return null;
            }
            this.admin = (PackageAdmin)this.getService(PackageAdmin.class, ref);
        }
        return this.admin;
    }

    protected FabResolverFactory getFabResolverFactory() {
        if (this.factory == null) {
            ServiceReference ref = this.getBundleContext().getServiceReference(FabResolverFactory.class.getName());
            if (ref == null) {
                System.out.println("FabResolverFactory service is unavailable.");
                return null;
            }
            this.factory = (FabResolverFactory)this.getService(FabResolverFactory.class, ref);
        }
        return this.factory;
    }

    protected OsgiModuleRegistry getModuleRegistry() {
        if (this.registry == null) {
            ServiceReference ref = this.getBundleContext().getServiceReference(OsgiModuleRegistry.class.getName());
            if (ref == null) {
                throw new IllegalStateException("ModuleRegistry service is unavailable.");
            }
            this.registry = (OsgiModuleRegistry)this.getService(OsgiModuleRegistry.class, ref);
        }
        return this.registry;
    }

    protected FabResolverFactoryImpl.FabResolverImpl getFabResolverImpl(String arg) throws MalformedURLException {
        return (FabResolverFactoryImpl.FabResolverImpl)this.getFabResolver(arg);
    }

    protected FabResolver getFabResolver(String arg) throws MalformedURLException {
        Bundle bundle;
        String url = arg;
        if (arg.matches("\\d+") && (bundle = this.getBundle(arg)) != null && (url = (String)bundle.getHeaders().get("FAB-URL")) == null) {
            this.println("Bundle %s is not a FAB - no %s bundle header found", arg, "FAB-URL");
            return null;
        }
        return this.getFabResolverFactory().getResolver(new URL(url));
    }

    protected void println() {
        this.session.getConsole().println();
    }

    protected void println(String msg, Object ... args) {
        this.session.getConsole().println(String.format(msg, args));
    }

    protected FabClassPathResolver createFabResolver(Bundle bundle) throws RepositoryException, IOException, XmlPullParserException, BundleException {
        Properties instructions = new Properties();
        Dictionary headers = bundle.getHeaders();
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = headers.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            instructions.setProperty((String)key, (String)value);
        }
        BundleFabFacade facade = new BundleFabFacade(bundle);
        HashMap<String, Object> embeddedResources = new HashMap<String, Object>();
        FabClassPathResolver resolver = new FabClassPathResolver(this.getModuleRegistry(), facade, instructions, embeddedResources);
        resolver.resolve();
        return resolver;
    }

    protected Bundle getBundle(String id) {
        try {
            return this.getBundle(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse bundle ID: " + id + ". Reason: " + e);
            return null;
        }
    }

    protected Bundle getBundle(long id) {
        Bundle bundle = this.bundleContext.getBundle(id);
        if (bundle == null) {
            System.err.println("Bundle ID " + id + " is invalid");
        }
        return bundle;
    }

    protected FabBundleInfo getFabBundleInfo(String url) {
        try {
            FabBundleInfo info = this.getFabResolverFactory().getResolver(new URL(url)).getInfo();
            info.getInputStream();
            return info;
        }
        catch (Exception e) {
            System.err.println("Unable to retrieve FAB info for " + url + ". Reason: " + e);
            return null;
        }
    }

    public static class Table {
        final String format;
        private final int[] col;
        final ArrayList<ArrayList<Object>> table = new ArrayList();

        public Table(String format, int ... col) {
            this.format = format;
            this.col = col;
        }

        public void add(Object ... values) {
            if (values.length != this.col.length) {
                throw new IllegalArgumentException("Expected " + this.col.length + " arguments");
            }
            this.table.add(new ArrayList<Object>(Arrays.asList(values)));
        }

        public void print(PrintStream out) {
            String fmt = this.format;
            for (int i = 0; i < this.col.length; ++i) {
                String token = "{" + (i + 1) + "}";
                if (!fmt.contains(token)) continue;
                if (this.col[i] != 0) {
                    int len = Math.abs(this.col[i]);
                    for (ArrayList<Object> row : this.table) {
                        Object o = row.get(i);
                        if (o == null) {
                            o = "";
                        }
                        String s = o.toString();
                        row.set(i, s);
                        len = Math.max(s.length(), len);
                    }
                    if (this.col[i] < 0) {
                        len *= -1;
                    }
                    fmt = fmt.replaceAll(Pattern.quote(token), "%" + len + "s");
                    continue;
                }
                fmt = fmt.replaceAll(Pattern.quote(token), "%s");
            }
            for (ArrayList<Object> row : this.table) {
                out.println(String.format(fmt, row.toArray()));
            }
        }
    }
}

