/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import org.osgi.service.metatype.AttributeDefinition;

public class MetaTypeAttributeDTO {
    private String id;
    private String name;
    private String description;
    private boolean required;
    private int cardinality;
    private String typeName;
    private String[] defaultValue;
    private String[] optionLabels;
    private String[] optionValues;

    public static String typeName(int type) {
        switch (type) {
            case 11: {
                return "boolean";
            }
            case 6: {
                return "byte";
            }
            case 5: {
                return "char";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "float";
            }
            case 3: {
                return "int";
            }
            case 2: {
                return "long";
            }
            case 12: {
                return "password";
            }
            case 4: {
                return "short";
            }
            case 1: {
                return "string";
            }
            case 10: {
                return "bigdecimal";
            }
            case 9: {
                return "bigint";
            }
        }
        return null;
    }

    public MetaTypeAttributeDTO() {
    }

    public MetaTypeAttributeDTO(AttributeDefinition definition, boolean required) {
        this.required = required;
        this.id = definition.getID();
        this.name = definition.getName();
        this.description = definition.getDescription();
        this.cardinality = definition.getCardinality();
        this.typeName = MetaTypeAttributeDTO.typeName(definition.getType());
        this.defaultValue = definition.getDefaultValue();
        this.optionLabels = definition.getOptionLabels();
        this.optionValues = definition.getOptionValues();
    }

    public String toString() {
        return "MetaTypeAttributeDTO{id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public String[] getOptionValues() {
        return this.optionValues;
    }

    public void setOptionValues(String[] optionValues) {
        this.optionValues = optionValues;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

