/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.VersionSequence;
import io.fabric8.internal.ProfileImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VersionImpl
implements Version {
    private final String id;
    private final FabricService service;
    private final VersionSequence sequence;

    public VersionImpl(String id, FabricService service) {
        this.id = id;
        this.service = service;
        this.sequence = new VersionSequence(id);
    }

    public String getName() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getAttributes() {
        return this.service.getDataStore().getVersionAttributes(this.id);
    }

    public void setAttribute(String key, String value) {
        this.service.getDataStore().setVersionAttribute(this.id, key, value);
    }

    public VersionSequence getSequence() {
        return this.sequence;
    }

    public int compareTo(Version that) {
        return this.sequence.compareTo(that.getSequence());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        return !(this.id != null ? !this.id.equals(version.id) : version.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public Version getDerivedFrom() {
        return null;
    }

    public Profile[] getProfiles() {
        List names = this.service.getDataStore().getProfiles(this.id);
        ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
        for (String name : names) {
            profiles.add(new ProfileImpl(name, this.id, this.service));
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    public Profile getProfile(String profileId) {
        if (this.service.getDataStore().hasProfile(this.id, profileId)) {
            return new ProfileImpl(profileId, this.id, this.service);
        }
        throw new FabricException("Profile '" + profileId + "' does not exist in version '" + this.id + "'.");
    }

    public Profile createProfile(String profileId) {
        this.service.getDataStore().createProfile(this.id, profileId);
        return new ProfileImpl(profileId, this.id, this.service);
    }

    public boolean hasProfile(String profileId) {
        return this.service.getDataStore().hasProfile(this.id, profileId);
    }

    public void copyProfile(String sourceId, String targetId, boolean force) {
        this.maybeDeleteProfile(targetId, force);
        for (Profile profile : this.getProfiles()) {
            if (!sourceId.equals(profile.getId())) continue;
            Profile targetProfile = this.createProfile(targetId);
            targetProfile.setParents(profile.getParents());
            targetProfile.setFileConfigurations(profile.getFileConfigurations());
            for (Map.Entry entry : profile.getAttributes().entrySet()) {
                targetProfile.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            return;
        }
    }

    private void maybeDeleteProfile(String targetId, boolean force) {
        Profile p;
        if (force && this.hasProfile(targetId) && (p = this.getProfile(targetId)) != null) {
            p.delete(force);
        }
    }

    public void renameProfile(String profileId, String newId, boolean force) {
        this.maybeDeleteProfile(newId, force);
        for (Profile profile : this.getProfiles()) {
            if (!profileId.equals(profile.getId())) continue;
            Profile targetProfile = this.createProfile(newId);
            targetProfile.setParents(profile.getParents());
            targetProfile.setConfigurations(profile.getConfigurations());
            for (Map.Entry entry : profile.getAttributes().entrySet()) {
                targetProfile.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            for (Container container : profile.getAssociatedContainers()) {
                Profile[] containerProfiles = container.getProfiles();
                HashSet<Profile> profileSet = new HashSet<Profile>(Arrays.asList(containerProfiles));
                profileSet.remove(profile);
                profileSet.add(targetProfile);
                container.setProfiles(profileSet.toArray(new Profile[profileSet.size()]));
            }
            this.maybeDeleteProfile(profileId, true);
            return;
        }
    }

    public void delete() {
        this.service.getDataStore().deleteVersion(this.id);
    }

    public String toString() {
        return this.id;
    }
}

