/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.commands.module;

import io.fabric8.fab.ModuleRegistry;
import io.fabric8.fab.osgi.commands.CommandSupport;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(name="search", scope="module", description="Search for all the available modules")
public class SearchCommand
extends CommandSupport {
    @Argument(index=0, required=false, description="Name of the module to list")
    private String name;

    protected Object doExecute() throws Exception {
        OsgiModuleRegistry registry = this.getModuleRegistry();
        List<ModuleRegistry.Module> modules = registry.getApplicationModules();
        CommandSupport.Table table = new CommandSupport.Table("{1} | {2} | {3}", -20, -10, -40);
        table.add("Name", "Version", "Description");
        for (ModuleRegistry.Module module : modules) {
            ModuleRegistry.VersionedModule latest = module.latest();
            if (this.name != null && module.getName().indexOf(this.name) < 0) continue;
            table.add(module.getName(), latest.getId().getVersion(), latest.getDescription());
        }
        table.print(this.session.getConsole());
        return null;
    }
}

