/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeAliasesUpdatedAction;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidAliasNameException;

public class MetaDataIndexAliasesService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final NodeAliasesUpdatedAction aliasOperationPerformedAction;

    @Inject
    public MetaDataIndexAliasesService(Settings settings, ClusterService clusterService, IndicesService indicesService, NodeAliasesUpdatedAction aliasOperationPerformedAction) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasOperationPerformedAction = aliasOperationPerformedAction;
    }

    public void indicesAliases(final Request request, final Listener listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                for (AliasAction aliasAction : request.actions) {
                    if (!currentState.metaData().hasIndex(aliasAction.index())) {
                        listener.onFailure(new IndexMissingException(new Index(aliasAction.index())));
                        return currentState;
                    }
                    if (currentState.metaData().hasIndex(aliasAction.alias())) {
                        listener.onFailure(new InvalidAliasNameException(new Index(aliasAction.index()), aliasAction.alias(), "an index exists with the same name as the alias"));
                        return currentState;
                    }
                    if (aliasAction.indexRouting() == null || aliasAction.indexRouting().indexOf(44) == -1) continue;
                    listener.onFailure(new ElasticSearchIllegalArgumentException("alias [" + aliasAction.alias() + "] has several routing values associated with it"));
                    return currentState;
                }
                ArrayList<String> indicesToClose = Lists.newArrayList();
                HashMap<String, IndexService> indices = Maps.newHashMap();
                try {
                    boolean changed = false;
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    for (AliasAction aliasAction : request.actions) {
                        IndexMetaData indexMetaData = builder.get(aliasAction.index());
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(aliasAction.index()));
                        }
                        IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.newIndexMetaDataBuilder(indexMetaData);
                        if (aliasAction.actionType() == AliasAction.Type.ADD) {
                            String filter = aliasAction.filter();
                            if (Strings.hasLength(filter)) {
                                IndexService indexService = (IndexService)indices.get(indexMetaData.index());
                                if (indexService == null) {
                                    indexService = MetaDataIndexAliasesService.this.indicesService.indexService(indexMetaData.index());
                                    if (indexService == null) {
                                        try {
                                            indexService = MetaDataIndexAliasesService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                                        }
                                        catch (Exception e) {
                                            MetaDataIndexAliasesService.this.logger.warn("[{}] failed to temporary create in order to apply alias action", e, indexMetaData.index());
                                            continue;
                                        }
                                        indicesToClose.add(indexMetaData.index());
                                    }
                                    indices.put(indexMetaData.index(), indexService);
                                }
                                IndexQueryParserService indexQueryParser = indexService.queryParserService();
                                try {
                                    XContentParser parser = XContentFactory.xContent(filter).createParser(filter);
                                    try {
                                        indexQueryParser.parseInnerFilter(parser);
                                    }
                                    finally {
                                        parser.close();
                                    }
                                }
                                catch (Exception e) {
                                    listener.onFailure(new ElasticSearchIllegalArgumentException("failed to parse filter for [" + aliasAction.alias() + "]", e));
                                    ClusterState clusterState = currentState;
                                    for (String index : indicesToClose) {
                                        MetaDataIndexAliasesService.this.indicesService.cleanIndex(index, "created for alias processing");
                                    }
                                    return clusterState;
                                }
                            }
                            AliasMetaData newAliasMd = AliasMetaData.newAliasMetaDataBuilder(aliasAction.alias()).filter(filter).indexRouting(aliasAction.indexRouting()).searchRouting(aliasAction.searchRouting()).build();
                            AliasMetaData aliasMd = indexMetaData.aliases().get(aliasAction.alias());
                            if (aliasMd != null && aliasMd.equals(newAliasMd)) continue;
                            indexMetaDataBuilder.putAlias(newAliasMd);
                        } else if (aliasAction.actionType() == AliasAction.Type.REMOVE) {
                            if (!indexMetaData.aliases().containsKey(aliasAction.alias())) continue;
                            indexMetaDataBuilder.removerAlias(aliasAction.alias());
                        }
                        changed = true;
                        builder.put(indexMetaDataBuilder);
                    }
                    if (changed) {
                        ClusterState updatedState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                        if (updatedState.metaData().aliases().equals(currentState.metaData().aliases())) {
                            listener.onResponse(new Response(true));
                            ClusterState len$ = currentState;
                            return len$;
                        }
                        int responseCount = updatedState.nodes().size();
                        long version = updatedState.version() + 1L;
                        MetaDataIndexAliasesService.this.logger.trace("waiting for [{}] notifications with version [{}]", responseCount, version);
                        MetaDataIndexAliasesService.this.aliasOperationPerformedAction.add(new CountDownListener(responseCount, listener, version), request.timeout);
                        ClusterState clusterState = updatedState;
                        return clusterState;
                    }
                    listener.onResponse(new Response(true));
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    for (String index : indicesToClose) {
                        MetaDataIndexAliasesService.this.indicesService.cleanIndex(index, "created for alias processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
            }
        });
    }

    private class CountDownListener
    implements NodeAliasesUpdatedAction.Listener {
        private final AtomicBoolean notified = new AtomicBoolean();
        private final AtomicInteger countDown;
        private final Listener listener;
        private final long version;

        public CountDownListener(int countDown, Listener listener, long version) {
            this.countDown = new AtomicInteger(countDown);
            this.listener = listener;
            this.version = version;
        }

        @Override
        public void onAliasesUpdated(NodeAliasesUpdatedAction.NodeAliasesUpdatedResponse response) {
            if (this.version <= response.version()) {
                MetaDataIndexAliasesService.this.logger.trace("Received NodeAliasesUpdatedResponse with version [{}] from [{}]", response.version(), response.nodeId());
                if (this.countDown.decrementAndGet() == 0) {
                    MetaDataIndexAliasesService.this.aliasOperationPerformedAction.remove(this);
                    if (this.notified.compareAndSet(false, true)) {
                        this.listener.onResponse(new Response(true));
                    }
                }
            }
        }

        @Override
        public void onTimeout() {
            MetaDataIndexAliasesService.this.aliasOperationPerformedAction.remove(this);
            if (this.notified.compareAndSet(false, true)) {
                this.listener.onResponse(new Response(false));
            }
        }
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class Request {
        final AliasAction[] actions;
        final TimeValue timeout;

        public Request(AliasAction[] actions, TimeValue timeout) {
            this.actions = actions;
            this.timeout = timeout;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }
}

