/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.doubles;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;

public class MultiValueDoubleFieldData
extends DoubleFieldData {
    private static final int VALUE_CACHE_SIZE = 10;
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value = new double[10][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new double[i];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value);
        }
    };
    private final int[][] ordinals;

    public MultiValueDoubleFieldData(String fieldName, int[][] ordinals, double[] values) {
        super(fieldName, values);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size = super.computeSizeInBytes();
        size += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, Double.toString(this.values[loc]));
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc.onValue(docId, (long)this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, (long)this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, DoubleFieldData.ValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onOrdinal(docId, 0);
                break;
            }
            proc.onOrdinal(docId, loc);
        }
    }

    @Override
    public double[] doubleValues(int docId) {
        return this.values(docId);
    }

    @Override
    public double value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return 0.0;
    }

    @Override
    public double[] values(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length;
        }
        if (length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length < 10 ? this.valuesCache.get().get()[length] : new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.values[this.ordinals[i][docId]];
        }
        return doubles;
    }
}

