/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.mvn;

import io.fabric8.agent.utils.NullArgumentException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class MavenRepositoryURL {
    private String m_id;
    private final URL m_repositoryURL;
    private final File m_file;
    private final boolean m_snapshotsEnabled;
    private final boolean m_releasesEnabled;

    public MavenRepositoryURL(String repositorySpec) throws MalformedURLException {
        NullArgumentException.validateNotEmpty(repositorySpec, true, "Repository spec");
        String[] segments = repositorySpec.split("@");
        StringBuilder urlBuilder = new StringBuilder();
        boolean snapshotEnabled = false;
        boolean releasesEnabled = true;
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].trim().equalsIgnoreCase("snapshots")) {
                snapshotEnabled = true;
                continue;
            }
            if (segments[i].trim().equalsIgnoreCase("noreleases")) {
                releasesEnabled = false;
                continue;
            }
            if (segments[i].trim().startsWith("id")) {
                if (segments[i].length() <= "id".length()) continue;
                this.m_id = segments[i].substring("id".length() + 1);
                continue;
            }
            if (i > 0) {
                urlBuilder.append("@");
            }
            urlBuilder.append(segments[i]);
        }
        String spec = urlBuilder.toString();
        if (!spec.endsWith("\\") && !spec.endsWith("/")) {
            spec = spec + "/";
        }
        this.m_repositoryURL = new URL(spec);
        this.m_snapshotsEnabled = snapshotEnabled;
        this.m_releasesEnabled = releasesEnabled;
        this.m_id = this.m_id != null ? this.m_id : "" + spec.hashCode();
        this.m_file = this.m_repositoryURL.getProtocol().equals("file") ? new File(this.m_repositoryURL.getPath()) : null;
    }

    public String getId() {
        return this.m_id;
    }

    public URL getURL() {
        return this.m_repositoryURL;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isReleasesEnabled() {
        return this.m_releasesEnabled;
    }

    public boolean isSnapshotsEnabled() {
        return this.m_snapshotsEnabled;
    }

    public boolean isFileRepository() {
        return this.m_file != null;
    }

    public String toString() {
        return this.m_repositoryURL.toString() + ",releases=" + this.m_releasesEnabled + ",snapshots=" + this.m_snapshotsEnabled;
    }
}

