/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.AbstractRouteCommand;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.util.ProcessorStatDump;
import org.apache.camel.util.RouteStatDump;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.util.StringEscapeUtils;

@Command(scope="camel", name="route-profile", description="Display profile information about Camel route(s).")
public class RouteProfile
extends AbstractRouteCommand {
    protected static final String HEADER_FORMAT = "%-30s %10s %12s %12s %12s %12s %12s %12s %12s";
    protected static final String OUTPUT_FORMAT = "%-30s %10d %12d %12d %12d %12d %12d %12d %12d";
    private String previousCamelContextName;

    @Override
    public Object doExecute() throws Exception {
        this.previousCamelContextName = null;
        return super.doExecute();
    }

    @Override
    public void executeOnRoute(CamelContext camelContext, Route camelRoute) throws Exception {
        ManagementAgent agent;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RouteStatDump.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.previousCamelContextName == null || !this.previousCamelContextName.equals(camelContext.getName())) {
            System.out.println("");
            System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mProfile\u001b[0m"));
            System.out.println(StringEscapeUtils.unescapeJava("\tCamel Context: " + camelRoute.getRouteContext().getCamelContext().getName()));
            System.out.println(String.format(HEADER_FORMAT, "Id", "Count", "Last (ms)", "Delta (ms)", "Mean (ms)", "Min (ms)", "Max (ms)", "Total (ms)", "Self (ms)"));
        }
        if ((agent = camelContext.getManagementStrategy().getManagementAgent()) != null) {
            MBeanServer mBeanServer = agent.getMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName(agent.getMBeanObjectDomainName() + ":type=routes,name=\"" + camelRoute.getId() + "\",*"), null);
            for (ObjectName routeMBean : set) {
                String camelId = (String)mBeanServer.getAttribute(routeMBean, "CamelId");
                if (camelId == null || !camelId.equals(camelContext.getName())) continue;
                String xml = (String)mBeanServer.invoke(routeMBean, "dumpRouteStatsAsXml", new Object[]{Boolean.FALSE, Boolean.TRUE}, new String[]{"boolean", "boolean"});
                RouteStatDump route = (RouteStatDump)unmarshaller.unmarshal((Reader)new StringReader(xml));
                long count = route.getExchangesCompleted() + route.getExchangesFailed();
                System.out.println(String.format(OUTPUT_FORMAT, route.getId(), count, route.getLastProcessingTime(), route.getDeltaProcessingTime(), route.getMeanProcessingTime(), route.getMinProcessingTime(), route.getMaxProcessingTime(), route.getTotalProcessingTime(), route.getSelfProcessingTime()));
                for (ProcessorStatDump ps : route.getProcessorStats()) {
                    long selfTime = ps.getTotalProcessingTime();
                    count = ps.getExchangesCompleted() + ps.getExchangesFailed();
                    System.out.println(String.format(OUTPUT_FORMAT, "  " + ps.getId(), count, ps.getLastProcessingTime(), ps.getDeltaProcessingTime(), ps.getMeanProcessingTime(), ps.getMinProcessingTime(), ps.getMaxProcessingTime(), ps.getAccumulatedProcessingTime(), selfTime));
                }
            }
        } else {
            System.out.println("");
            System.out.println(StringEscapeUtils.unescapeJava("\u001b[31mJMX Agent of Camel is not reachable. Maybe it has been disabled on the Camel context"));
            System.out.println(StringEscapeUtils.unescapeJava("In consequence, profile are not available.\u001b[0m"));
        }
        this.previousCamelContextName = camelContext.getName();
    }
}

