/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.redirect;

import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectServlet
extends HttpServlet
implements ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectServlet.class);
    public static final String REDIRECT = "redirect";
    private String redirect = "/hawtio";
    private String[] validRedirectRequests = new String[]{"/", "/index.html"};
    private Set<String> validRedirectRequestSet;

    public String[] getValidRedirectRequests() {
        return this.validRedirectRequests;
    }

    public void setValidRedirectRequests(String[] validRedirectRequests) {
        this.validRedirectRequests = validRedirectRequests;
    }

    public Set<String> getValidRedirectRequestSet() {
        if (this.validRedirectRequestSet == null) {
            this.validRedirectRequestSet = new HashSet<String>(Arrays.asList(this.getValidRedirectRequests()));
        }
        return this.validRedirectRequestSet;
    }

    public String toString() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + bundle.getSymbolicName() + " - " + bundle.getBundleId() + " to: " + this.getRedirect() + "}";
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRedirect(req, resp);
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public void updated(Dictionary props) throws ConfigurationException {
        String text;
        Object value;
        if (props != null && (value = props.get(REDIRECT)) instanceof String && Strings.isNotBlank(text = value.toString())) {
            this.redirect = text;
        }
        this.recreateValidRedirectRequestSet();
    }

    protected void doRedirect(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestURI = req.getRequestURI();
        if (Strings.isNullOrBlank(requestURI) || this.getValidRedirectRequestSet().contains(requestURI)) {
            String url = this.getRedirect();
            LOGGER.debug("Redirect: {} to: {}", (Object)requestURI, (Object)url);
            resp.sendRedirect(url);
        } else {
            LOGGER.debug("Resource not found: {} returning status code: 404", (Object)requestURI);
            resp.setStatus(404);
            resp.setContentLength(0);
            resp.flushBuffer();
        }
    }

    protected void recreateValidRedirectRequestSet() {
        this.validRedirectRequestSet = null;
        this.getValidRedirectRequestSet();
    }
}

