/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.bnd.maven.Pom;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.libg.cryptography.Digester;
import aQute.libg.cryptography.MD5;
import aQute.libg.cryptography.SHA1;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven {
    final File userHome = new File(System.getProperty("user.home"));
    final File m2 = new File(this.userHome, ".m2");
    final File repository = new File(this.m2, "repository");
    final Map<String, Pom> poms = new ConcurrentHashMap<String, Pom>();
    final List<URL> repositories = new ArrayList<URL>();
    final String[] ALGORITHMS = new String[]{"md5", "sha1"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pom getPom(String groupId, String artifactId, String version, URL ... extra) throws Exception {
        Pom pom;
        String pomPath = this.pom(groupId, artifactId, version);
        File pomFile = IO.getFile(this.repository, pomPath);
        Map<String, Pom> map = this.poms;
        synchronized (map) {
            pom = this.poms.get(pomPath);
            if (pom != null) {
                return pom;
            }
            pom = new Pom(this);
            this.poms.put(pomPath, pom);
            if (pomFile.isFile()) {
                this.verify(pomFile);
                pom.setFile(pomFile);
                return pom;
            }
        }
        try {
            this.download(pomPath, pomFile, new URL[0]);
            pom.setFile(pomFile);
            return pom;
        }
        catch (Exception e) {
            pom.exception = e;
            throw e;
        }
    }

    private void download(String path, File file, URL ... extra) throws Exception {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        for (URL url : extra) {
            if (url == null) continue;
            set.add(url);
        }
        set.addAll(this.repositories);
        if (set.isEmpty()) {
            set.add(new URL("http://repo1.maven.org/maven2/"));
        }
        file.getParentFile().mkdirs();
        for (URL repo : set) {
            try {
                URL url = new URL(repo, path);
                System.out.println("Downloading " + url);
                IO.copy(url.openStream(), file);
                for (String alg : this.ALGORITHMS) {
                    try {
                        IO.copy(new URL(url.toExternalForm() + "." + alg).openStream(), file);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to copy checksum " + alg + " " + e);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Download failed due to " + e);
            }
        }
        file.delete();
        throw new FileNotFoundException(path + " in " + set);
    }

    private void verify(File file) throws Exception {
        this.verify(file, MD5.getDigester());
        this.verify(file, SHA1.getDigester());
    }

    private void verify(File file, Digester<?> digester) throws Exception {
        File newFile = new File(file.getAbsolutePath() + "." + digester.getAlgorithm().toLowerCase());
        if (!newFile.isFile()) {
            return;
        }
        IO.copy(file, digester);
        digester.flush();
        byte[] digest = digester.getMessageDigest().digest();
        String s = IO.collect(newFile).toUpperCase();
        String hex = Hex.toHexString(digest).toUpperCase();
        if (s.startsWith(hex)) {
            System.out.println("Verified ok " + file);
            return;
        }
        throw new InvalidObjectException(String.format("Failed to verify %s checksum for %s", digester.getAlgorithm(), file));
    }

    private String path(String groupId, String artifactId, String version) {
        return groupId.replace('.', '/') + '/' + artifactId + '/' + version;
    }

    private String pom(String groupId, String artifactId, String version) {
        return this.path(groupId, artifactId, version) + "/" + artifactId + "-" + version + ".pom";
    }

    private String artifact(String groupId, String artifactId, String version) {
        return this.path(groupId, artifactId, version) + "/" + artifactId + "-" + version + ".jar";
    }

    public File getArtifact(String groupId, String artifactId, String version, URL ... urls) throws Exception {
        String path = this.artifact(groupId, artifactId, version);
        File file = IO.getFile(this.repository, path);
        if (file.isFile()) {
            return file;
        }
        this.download(path, file, urls);
        return file;
    }
}

