## QuickStarts

This folder containers various quickstart examples to help you get started with the various aspects of [JBoss Fuse](http://www.jboss.org/products/fuse).

### [Apache Camel](http://camel.apache.org/) based quick starts

* [cbr](/fabric/profiles/example/quickstarts/cbr.profile) demonstrates how to use a Content Based Router using [Apache Camel](http://camel.apache.org/)
* [cbr.wiki](/fabric/profiles/example/quickstarts/cbr.wiki.profile) is the same Content Based Router demo but where the [Camel route](http://camel.apache.org/) is stored inside the wiki so it can be easily changed via the Management Console
* [eip](/fabric/profiles/example/quickstarts/eip.profile) demonstrates how to use Enterprise Integration Patterns using [Apache Camel](http://camel.apache.org/)
* [errors](/fabric/profiles/example/quickstarts/errors.profile) demonstrates how to perform Error Handling in [Apache Camel](http://camel.apache.org/)
* [more examples](/fabric/profiles/example/camel) various other examples for working with [Apache Camel](http://camel.apache.org/) and Fuse

### [Apache ActiveMQ](http://activemq.apache.org/) based quick starts

* [jms](/fabric/profiles/example/quickstarts/jms.profile) demonstrates how to send and receive messages with JMS using [Apache ActiveMQ](http://activemq.apache.org/)

### [Apache CXF](http://cxf.apache.org/) based quick starts

* [rest](/fabric/profiles/example/quickstarts/rest.profile) demonstrates how to write restful services using [Apache CXF](http://cxf.apache.org/)
* [soap](/fabric/profiles/example/quickstarts/soap.profile) demonstrates how to write SOAP services using [Apache CXF](http://cxf.apache.org/)
* [secure.rest](/fabric/profiles/example/quickstarts/secure.rest.profile) demonstrates how to write Secure REST services using [Apache CXF](http://cxf.apache.org/)
* [secure.soap](/fabric/profiles/example/quickstarts/secure.soap.profile) demonstrates how to write Secure SOAP services using [Apache CXF](http://cxf.apache.org/)