/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlaceholderResolverHelpers {
    public static final Pattern SCHEME_PATTERN = Pattern.compile("\\$\\{([^ :\\}]+):([^\\}]*\\})");

    private PlaceholderResolverHelpers() {
    }

    public static Set<String> getSchemeForValue(String value) {
        HashSet<String> schemes = new HashSet<String>();
        Matcher matcher = SCHEME_PATTERN.matcher(value);
        while (matcher.find()) {
            String scheme = matcher.group(1);
            schemes.add(scheme);
            String remaining = matcher.group(2);
            if (remaining == null) continue;
            schemes.addAll(PlaceholderResolverHelpers.getSchemeForValue(remaining));
        }
        return schemes;
    }

    public static Set<String> getSchemesForConfig(Map<String, String> props) {
        HashSet<String> schemes = new HashSet<String>();
        for (Map.Entry<String, String> e : props.entrySet()) {
            String value = e.getValue();
            schemes.addAll(PlaceholderResolverHelpers.getSchemeForValue(value));
        }
        return schemes;
    }

    public static Set<String> getSchemesForProfileConfigurations(Map<String, Map<String, String>> configs) {
        HashSet<String> schemes = new HashSet<String>();
        for (Map.Entry<String, Map<String, String>> e : configs.entrySet()) {
            Map<String, String> value = e.getValue();
            schemes.addAll(PlaceholderResolverHelpers.getSchemesForConfig(value));
        }
        return schemes;
    }
}

