/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerAutoScalerFactory;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateChildContainerMetadata;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.PortService;
import io.fabric8.api.Profile;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.internal.ContainerImpl;
import io.fabric8.internal.ProfileOverlayImpl;
import io.fabric8.service.ChildAutoScaler;
import io.fabric8.service.ContainerTemplate;
import io.fabric8.utils.AuthenticationUtils;
import io.fabric8.utils.Ports;
import io.fabric8.utils.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.admin.management.AdminServiceMBean;

@ThreadSafe
@Component(name="io.fabric8.container.provider.child", label="Fabric8 Child Container Provider", immediate=true, metatype=false)
@Service(value={ContainerProvider.class})
public final class ChildContainerProvider
extends AbstractComponent
implements ContainerProvider<CreateChildContainerOptions, CreateChildContainerMetadata>,
ContainerAutoScalerFactory {
    private static final String SCHEME = "child";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public CreateChildContainerOptions.Builder newBuilder() {
        return CreateChildContainerOptions.builder();
    }

    public CreateChildContainerMetadata create(final CreateChildContainerOptions options, final CreationStateListener listener) throws Exception {
        this.assertValid();
        final Container parent = ((FabricService)this.fabricService.get()).getContainer(options.getParent());
        ContainerTemplate containerTemplate = new ContainerTemplate(parent, options.getJmxUser(), options.getJmxPassword(), false);
        return containerTemplate.execute(new ContainerTemplate.AdminServiceCallback<CreateChildContainerMetadata>(){

            @Override
            public CreateChildContainerMetadata doWithAdminService(AdminServiceMBean adminService) throws Exception {
                return ChildContainerProvider.this.doCreate(adminService, options, listener, parent);
            }
        });
    }

    private CreateChildContainerMetadata doCreate(AdminServiceMBean adminService, CreateChildContainerOptions options, CreationStateListener listener, final Container parent) throws Exception {
        StringBuilder jvmOptsBuilder = new StringBuilder();
        String zkPasswordEncode = System.getProperty("zookeeper.password.encode", "true");
        jvmOptsBuilder.append("-server -Dcom.sun.management.jmxremote").append(options.getZookeeperUrl() != null ? " -Dzookeeper.url=\"" + options.getZookeeperUrl() + "\"" : "").append(zkPasswordEncode != null ? " -Dzookeeper.password.encode=\"" + zkPasswordEncode + "\"" : "").append(options.getZookeeperPassword() != null ? " -Dzookeeper.password=\"" + options.getZookeeperPassword() + "\"" : "");
        if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-Xmx")) {
            jvmOptsBuilder.append(" -Xmx512m");
        }
        if (options.isEnsembleServer()) {
            jvmOptsBuilder.append(" ").append("ensemble.auto.start=true");
        }
        if (options.getJvmOpts() != null && !options.getJvmOpts().isEmpty()) {
            jvmOptsBuilder.append(" ").append(options.getJvmOpts());
        }
        if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass")) {
            jvmOptsBuilder.append(" -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass");
        }
        if (options.getBindAddress() != null && !options.getBindAddress().isEmpty()) {
            jvmOptsBuilder.append(" -Dbind.address=" + options.getBindAddress());
        }
        if (options.getResolver() != null && !options.getResolver().isEmpty()) {
            jvmOptsBuilder.append(" -Dlocal.resolver=" + options.getResolver());
        }
        if (options.getManualIp() != null && !options.getManualIp().isEmpty()) {
            jvmOptsBuilder.append(" -Dmanualip=" + options.getManualIp());
        }
        FabricService fservice = (FabricService)this.fabricService.get();
        HashMap<String, String> dataStoreProperties = new HashMap<String, String>(options.getDataStoreProperties());
        dataStoreProperties.put("type", fservice.getDataStore().getType());
        for (Map.Entry dataStoreEntries : options.getDataStoreProperties().entrySet()) {
            String key = (String)dataStoreEntries.getKey();
            String value = (String)dataStoreEntries.getValue();
            jvmOptsBuilder.append(" -Dio.fabric8.datastore." + key + "=" + value);
        }
        Profile profile = parent.getVersion().getProfile("default");
        ProfileOverlayImpl defaultProfile = new ProfileOverlayImpl(profile, fservice.getEnvironment(), true, fservice);
        String featuresUrls = ChildContainerProvider.collectionAsString(defaultProfile.getRepositories());
        LinkedHashSet<String> features = new LinkedHashSet<String>();
        features.add("fabric-agent");
        features.add("fabric-git");
        String containerName = options.getName();
        PortService portService = fservice.getPortService();
        Set usedPorts = portService.findUsedPortByHost(parent);
        CreateChildContainerMetadata metadata = new CreateChildContainerMetadata();
        metadata.setCreateOptions((CreateContainerOptions)options);
        metadata.setContainerName(containerName);
        int minimumPort = parent.getMinimumPort();
        int maximumPort = parent.getMaximumPort();
        fservice.getDataStore().setContainerAttribute(containerName, DataStore.ContainerAttribute.PortMin, String.valueOf(minimumPort));
        fservice.getDataStore().setContainerAttribute(containerName, DataStore.ContainerAttribute.PortMax, String.valueOf(maximumPort));
        this.inheritAddresses(fservice, parent.getId(), containerName, options);
        ContainerImpl child = new ContainerImpl(parent, containerName, fservice){

            @Override
            public String getIp() {
                return parent.getIp();
            }
        };
        int sshFrom = Ports.mapPortToRange(8101, minimumPort, maximumPort);
        int sshTo = Ports.mapPortToRange(8201, minimumPort, maximumPort);
        int sshPort = portService.registerPort((Container)child, "org.apache.karaf.shell", "sshPort", sshFrom, sshTo, usedPorts);
        int httpFrom = Ports.mapPortToRange(8181, minimumPort, maximumPort);
        int httpTo = Ports.mapPortToRange(8281, minimumPort, maximumPort);
        portService.registerPort((Container)child, "org.ops4j.pax.web", "org.osgi.service.http.port", httpFrom, httpTo, usedPorts);
        int rmiServerFrom = Ports.mapPortToRange(44444, minimumPort, maximumPort);
        int rmiServerTo = Ports.mapPortToRange(44544, minimumPort, maximumPort);
        int rmiServerPort = portService.registerPort((Container)child, "org.apache.karaf.management", "rmiServerPort", rmiServerFrom, rmiServerTo, usedPorts);
        int rmiRegistryFrom = Ports.mapPortToRange(1099, minimumPort, maximumPort);
        int rmiRegistryTo = Ports.mapPortToRange(1199, minimumPort, maximumPort);
        int rmiRegistryPort = portService.registerPort((Container)child, "org.apache.karaf.management", "rmiRegistryPort", rmiRegistryFrom, rmiRegistryTo, usedPorts);
        try {
            adminService.createInstance(containerName, sshPort, rmiRegistryPort, rmiServerPort, null, jvmOptsBuilder.toString(), ChildContainerProvider.collectionAsString(features), featuresUrls);
            adminService.startInstance(containerName, null);
        }
        catch (Throwable t) {
            metadata.setFailure(t);
        }
        return metadata;
    }

    public void start(final Container container) {
        this.assertValid();
        this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.startInstance(container.getId(), null);
                return null;
            }
        });
    }

    public void stop(final Container container) {
        this.assertValid();
        this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.stopInstance(container.getId());
                return null;
            }
        });
    }

    public void destroy(final Container container) {
        this.assertValid();
        this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.destroyInstance(container.getId());
                return null;
            }
        });
    }

    public String getScheme() {
        return SCHEME;
    }

    public Class<CreateChildContainerOptions> getOptionsType() {
        return CreateChildContainerOptions.class;
    }

    public Class<CreateChildContainerMetadata> getMetadataType() {
        return CreateChildContainerMetadata.class;
    }

    public boolean isValidProvider() {
        boolean openshiftFuseEnv = Strings.notEmpty(System.getenv("OPENSHIFT_FUSE_DIR"));
        boolean openshiftAmqEnv = Strings.notEmpty(System.getenv("OPENSHIFT_AMQ_DIR"));
        return !openshiftFuseEnv && !openshiftAmqEnv;
    }

    public ContainerAutoScaler createAutoScaler() {
        return new ChildAutoScaler(this);
    }

    private ContainerTemplate getContainerTemplateForChild(Container container) {
        CreateChildContainerOptions options = (CreateChildContainerOptions)container.getMetadata().getCreateOptions();
        String username = AuthenticationUtils.retrieveJaasUser();
        String password = AuthenticationUtils.retrieveJaasPassword();
        if (username != null && password != null) {
            options = (CreateChildContainerOptions)options.updateCredentials(username, password);
        }
        return new ContainerTemplate(container.getParent(), options.getJmxUser(), options.getJmxPassword(), false);
    }

    private void inheritAddresses(FabricService service, String parent, String name, CreateChildContainerOptions options) throws Exception {
        if (options.getManualIp() != null) {
            service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.ManualIp, options.getManualIp());
        } else {
            service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.ManualIp, "${zk:" + parent + "/manualip}");
        }
        service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.LocalHostName, "${zk:" + parent + "/localhostname}");
        service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.LocalIp, "${zk:" + parent + "/localip}");
        service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.PublicIp, "${zk:" + parent + "/publicip}");
        if (options.getResolver() != null) {
            service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.Resolver, options.getResolver());
        } else {
            service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.Resolver, "${zk:" + parent + "/resolver}");
        }
        if (options.getBindAddress() != null) {
            service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.BindAddress, options.getBindAddress());
        } else {
            service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.BindAddress, "${zk:" + parent + "/bindaddress}");
        }
        service.getDataStore().setContainerAttribute(name, DataStore.ContainerAttribute.Ip, "${zk:" + name + "/${zk:" + name + "/resolver}}");
    }

    FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    private static String collectionAsString(Collection<String> value) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (value != null) {
            for (String el : value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(el);
            }
        }
        return sb.toString();
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }
}

