/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.internal.BundleInfoImpl;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Overrides {
    private static final Logger LOGGER = LoggerFactory.getLogger(Overrides.class);
    protected static final String OVERRIDE_RANGE = "range";
    protected static Map<String, Manifest> manifests = new ConcurrentHashMap<String, Manifest>();

    public static List<BundleInfo> override(List<BundleInfo> infos, String overridesUrl) {
        List<Clause> overrides = Overrides.loadOverrides(overridesUrl);
        if (overrides.isEmpty()) {
            return infos;
        }
        try {
            for (Clause override : overrides) {
                Manifest manifest;
                if (manifests.containsKey(override.getName()) || (manifest = Overrides.getManifest(override.getName())) == null) continue;
                manifests.put(override.getName(), manifest);
            }
            ArrayList<BundleInfo> newInfos = new ArrayList<BundleInfo>();
            for (BundleInfo info : infos) {
                Manifest manifest;
                Manifest manifest2 = manifest = !manifests.containsKey(info.getLocation()) ? Overrides.getManifest(info.getLocation()) : manifests.get(info.getLocation());
                if (manifest != null) {
                    String bsn = Overrides.getBundleSymbolicName(manifest);
                    Version ver = Overrides.getBundleVersion(manifest);
                    String url = info.getLocation();
                    for (Clause override : overrides) {
                        VersionRange range;
                        String oBsn;
                        Manifest overMan = manifests.get(override.getName());
                        if (overMan == null || !bsn.equals(oBsn = Overrides.getBundleSymbolicName(overMan))) continue;
                        Version oVer = Overrides.getBundleVersion(overMan);
                        String vr = Overrides.extractVersionRange(override);
                        if (vr == null) {
                            Version v2 = new Version(oVer.getMajor(), oVer.getMinor(), 0);
                            if (v2.equals((Object)oVer)) continue;
                            range = new VersionRange(false, v2, oVer, true);
                        } else {
                            range = VersionRange.parseVersionRange(vr);
                        }
                        if (!range.contains(ver) || ver.compareTo(oVer) >= 0) continue;
                        ver = oVer;
                        url = override.getName();
                    }
                    if (!info.getLocation().equals(url)) {
                        newInfos.add(new BundleInfoImpl(url, info.getStartLevel(), info.isStart(), info.isDependency()));
                        continue;
                    }
                    newInfos.add(info);
                    continue;
                }
                newInfos.add(info);
            }
            return newInfos;
        }
        catch (Exception e) {
            LOGGER.info("Unable to process bundle overrides", (Throwable)e);
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Clause> loadOverrides(String overridesUrl) {
        ArrayList<Clause> overrides;
        block7: {
            overrides = new ArrayList<Clause>();
            try {
                String mfPath = System.getProperty("karaf.home") + File.separatorChar + "patches" + File.separatorChar + "manifest-cache";
                File mfFile = new File(mfPath);
                mfFile.mkdirs();
                if (overridesUrl == null) break block7;
                InputStream is = new URL(overridesUrl).openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        Clause[] cs;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        for (Clause c : cs = Parser.parseClauses((String[])new String[]{line})) {
                            overrides.add(c);
                        }
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load overrides bundles list", (Throwable)e);
            }
        }
        return overrides;
    }

    private static Version getBundleVersion(Manifest manifest) {
        String ver = manifest.getMainAttributes().getValue("Bundle-Version");
        return VersionTable.getVersion(ver);
    }

    private static String getBundleSymbolicName(Manifest manifest) {
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        bsn = Overrides.stripSymbolicName(bsn);
        return bsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest getManifest(String url) throws IOException {
        boolean cacheMf = false;
        File mfFile = null;
        try {
            String mfPath = System.getProperty("karaf.home") + File.separatorChar + "patches" + File.separatorChar + "manifest-cache" + File.separatorChar + url.replace(File.separatorChar, '#').replace('/', '#').replace(':', '#') + ".mf";
            mfFile = new File(mfPath);
            if (mfFile.exists()) {
                FileInputStream is2 = null;
                try {
                    is2 = new FileInputStream(mfFile);
                    Manifest manifest = new Manifest(is2);
                    return manifest;
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            cacheMf = true;
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't load cached manifest for " + url, (Throwable)e);
        }
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            do {
                if ((entry = zis.getNextEntry()) == null) return null;
            } while (!"META-INF/MANIFEST.MF".equals(entry.getName()));
            Manifest manifest = new Manifest(zis);
            if (cacheMf) {
                FileOutputStream os = null;
                try {
                    if (mfFile != null) {
                        mfFile.getParentFile().mkdirs();
                        os = new FileOutputStream(mfFile);
                        manifest.write(os);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Couldn't write manifest to cache for " + url);
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't load manifest for " + url, (Throwable)e);
            return null;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static String extractVersionRange(Clause override) {
        return override.getAttribute(OVERRIDE_RANGE);
    }

    private static String stripSymbolicName(String symbolicName) {
        Clause[] cs = Parser.parseHeader((String)symbolicName);
        if (cs == null || cs.length != 1) {
            throw new IllegalArgumentException("Bad Bundle-SymbolicName header: " + symbolicName);
        }
        return cs[0].getName();
    }
}

