/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.support;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.fusesource.process.manager.support.command.Command;
import org.fusesource.process.manager.support.command.CommandFailedException;
import org.fusesource.process.manager.support.command.Duration;

public class FileUtils {
    public static void extractArchive(File archiveFile, File targetDirectory, String extractCommand, Duration timeLimit, Executor executor) throws CommandFailedException {
        Preconditions.checkNotNull((Object)archiveFile, (Object)"archiveFile is null");
        Preconditions.checkNotNull((Object)targetDirectory, (Object)"targetDirectory is null");
        Preconditions.checkArgument((boolean)targetDirectory.isDirectory(), (Object)("targetDirectory is not a directory: " + targetDirectory.getAbsolutePath()));
        String[] commands = extractCommand.split(" ");
        String[] args = Arrays.copyOf(commands, commands.length + 1);
        args[args.length - 1] = archiveFile.getAbsolutePath();
        new Command(args).setDirectory(targetDirectory).setTimeLimit(timeLimit).execute(executor);
    }
}

