/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javaewah.EWAHCompressedBitmap;
import javaewah.IntIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BitSet;
import org.eclipse.jgit.internal.storage.file.InflatingBitSet;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapObject;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.BlockList;

public class BitmapIndexImpl
implements BitmapIndex {
    private static final int EXTRA_BITS = 10240;
    private final PackBitmapIndex packIndex;
    private final MutableBitmapIndex mutableIndex;
    private final int indexObjectCount;

    public BitmapIndexImpl(PackBitmapIndex packIndex) {
        this.packIndex = packIndex;
        this.mutableIndex = new MutableBitmapIndex();
        this.indexObjectCount = packIndex.getObjectCount();
    }

    PackBitmapIndex getPackBitmapIndex() {
        return this.packIndex;
    }

    public CompressedBitmap getBitmap(AnyObjectId objectId) {
        EWAHCompressedBitmap compressed = this.packIndex.getBitmap(objectId);
        if (compressed == null) {
            return null;
        }
        return new CompressedBitmap(compressed);
    }

    public CompressedBitmapBuilder newBitmapBuilder() {
        return new CompressedBitmapBuilder();
    }

    private int findPosition(AnyObjectId objectId) {
        int position = this.packIndex.findPosition(objectId);
        if (position < 0 && (position = this.mutableIndex.findPosition(objectId)) >= 0) {
            position += this.indexObjectCount;
        }
        return position;
    }

    private int addObject(AnyObjectId objectId, int type) {
        int position = this.findPosition(objectId);
        if (position < 0) {
            position = this.mutableIndex.addObject(objectId, type);
            position += this.indexObjectCount;
        }
        return position;
    }

    private boolean isSameCompressedBitmap(BitmapIndex.Bitmap other) {
        if (other instanceof CompressedBitmap) {
            CompressedBitmap b = (CompressedBitmap)other;
            return this == b.getPackBitmapIndex();
        }
        return false;
    }

    private boolean isSameCompressedBitmapBuilder(BitmapIndex.Bitmap other) {
        if (other instanceof CompressedBitmapBuilder) {
            CompressedBitmapBuilder b = (CompressedBitmapBuilder)other;
            return this == b.getBitmapIndex();
        }
        return false;
    }

    private static final EWAHCompressedBitmap ones(int sizeInBits) {
        EWAHCompressedBitmap mask = new EWAHCompressedBitmap();
        mask.addStreamOfEmptyWords(true, sizeInBits / 64);
        int remaining = sizeInBits % 64;
        if (remaining > 0) {
            mask.add((1L << remaining) - 1L, remaining);
        }
        return mask;
    }

    private static final class BitmapObjectImpl
    extends BitmapObject {
        private ObjectId objectId;
        private int type;

        private BitmapObjectImpl() {
        }

        public ObjectId getObjectId() {
            return this.objectId;
        }

        public int getType() {
            return this.type;
        }
    }

    private static final class ComboBitset {
        private InflatingBitSet inflatingBitmap;
        private BitSet toAdd;
        private BitSet toRemove;

        private ComboBitset() {
            this(new EWAHCompressedBitmap());
        }

        private ComboBitset(EWAHCompressedBitmap bitmap) {
            this.inflatingBitmap = new InflatingBitSet(bitmap);
        }

        EWAHCompressedBitmap combine() {
            EWAHCompressedBitmap toAddCompressed = null;
            if (this.toAdd != null) {
                toAddCompressed = this.toAdd.toEWAHCompressedBitmap();
                this.toAdd = null;
            }
            EWAHCompressedBitmap toRemoveCompressed = null;
            if (this.toRemove != null) {
                toRemoveCompressed = this.toRemove.toEWAHCompressedBitmap();
                this.toRemove = null;
            }
            if (toAddCompressed != null) {
                this.or(toAddCompressed);
            }
            if (toRemoveCompressed != null) {
                this.andNot(toRemoveCompressed);
            }
            return this.inflatingBitmap.getBitmap();
        }

        void or(EWAHCompressedBitmap inbits) {
            if (this.toRemove != null) {
                this.combine();
            }
            this.inflatingBitmap = this.inflatingBitmap.or(inbits);
        }

        void andNot(EWAHCompressedBitmap inbits) {
            if (this.toAdd != null || this.toRemove != null) {
                this.combine();
            }
            this.inflatingBitmap = this.inflatingBitmap.andNot(inbits);
        }

        void xor(EWAHCompressedBitmap inbits) {
            if (this.toAdd != null || this.toRemove != null) {
                this.combine();
            }
            this.inflatingBitmap = this.inflatingBitmap.xor(inbits);
        }

        boolean contains(int position) {
            if (this.toRemove != null && this.toRemove.get(position)) {
                return false;
            }
            if (this.toAdd != null && this.toAdd.get(position)) {
                return true;
            }
            return this.inflatingBitmap.contains(position);
        }

        void remove(int position) {
            if (this.toAdd != null) {
                this.toAdd.clear(position);
            }
            if (this.inflatingBitmap.maybeContains(position)) {
                if (this.toRemove == null) {
                    this.toRemove = new BitSet(position + 10240);
                }
                this.toRemove.set(position);
            }
        }

        void set(int position) {
            if (this.toRemove != null) {
                this.toRemove.clear(position);
            }
            if (this.toAdd == null) {
                this.toAdd = new BitSet(position + 10240);
            }
            this.toAdd.set(position);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CompressedBitmap
    implements BitmapIndex.Bitmap {
        private final EWAHCompressedBitmap bitmap;

        private CompressedBitmap(EWAHCompressedBitmap bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public CompressedBitmap or(BitmapIndex.Bitmap other) {
            return new CompressedBitmap(this.bitmap.or(this.bitmapOf(other)));
        }

        @Override
        public CompressedBitmap andNot(BitmapIndex.Bitmap other) {
            return new CompressedBitmap(this.bitmap.andNot(this.bitmapOf(other)));
        }

        @Override
        public CompressedBitmap xor(BitmapIndex.Bitmap other) {
            return new CompressedBitmap(this.bitmap.xor(this.bitmapOf(other)));
        }

        private EWAHCompressedBitmap bitmapOf(BitmapIndex.Bitmap other) {
            if (BitmapIndexImpl.this.isSameCompressedBitmap(other)) {
                return ((CompressedBitmap)other).bitmap;
            }
            if (BitmapIndexImpl.this.isSameCompressedBitmapBuilder(other)) {
                return ((CompressedBitmapBuilder)other).build().bitmap;
            }
            CompressedBitmapBuilder builder = BitmapIndexImpl.this.newBitmapBuilder();
            builder.or(other);
            return builder.build().bitmap;
        }

        private final IntIterator ofObjectType(int type) {
            return BitmapIndexImpl.this.packIndex.ofObjectType(this.bitmap, type).intIterator();
        }

        @Override
        public Iterator<BitmapObject> iterator() {
            final IntIterator dynamic = this.bitmap.andNot(BitmapIndexImpl.ones(BitmapIndexImpl.this.indexObjectCount)).intIterator();
            final IntIterator commits = this.ofObjectType(1);
            final IntIterator trees = this.ofObjectType(2);
            final IntIterator blobs = this.ofObjectType(3);
            final IntIterator tags = this.ofObjectType(4);
            return new Iterator<BitmapObject>(){
                private final BitmapObjectImpl out = new BitmapObjectImpl();
                private int type;
                private IntIterator cached = dynamic;

                @Override
                public boolean hasNext() {
                    if (!this.cached.hasNext()) {
                        if (commits.hasNext()) {
                            this.type = 1;
                            this.cached = commits;
                        } else if (trees.hasNext()) {
                            this.type = 2;
                            this.cached = trees;
                        } else if (blobs.hasNext()) {
                            this.type = 3;
                            this.cached = blobs;
                        } else if (tags.hasNext()) {
                            this.type = 4;
                            this.cached = tags;
                        } else {
                            return false;
                        }
                    }
                    return true;
                }

                @Override
                public BitmapObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int position = this.cached.next();
                    if (position < BitmapIndexImpl.this.indexObjectCount) {
                        this.out.type = this.type;
                        this.out.objectId = BitmapIndexImpl.this.packIndex.getObject(position);
                    } else {
                        MutableEntry entry = BitmapIndexImpl.this.mutableIndex.getObject(position -= BitmapIndexImpl.this.indexObjectCount);
                        this.out.type = entry.type;
                        this.out.objectId = entry;
                    }
                    return this.out;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        EWAHCompressedBitmap getEwahCompressedBitmap() {
            return this.bitmap;
        }

        private BitmapIndexImpl getPackBitmapIndex() {
            return BitmapIndexImpl.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompressedBitmapBuilder
    implements BitmapIndex.BitmapBuilder {
        private ComboBitset bitset = new ComboBitset();

        private CompressedBitmapBuilder() {
        }

        @Override
        public boolean add(AnyObjectId objectId, int type) {
            int position = BitmapIndexImpl.this.addObject(objectId, type);
            if (this.bitset.contains(position)) {
                return false;
            }
            CompressedBitmap entry = BitmapIndexImpl.this.getBitmap(objectId);
            if (entry != null) {
                this.or(entry);
                return false;
            }
            this.bitset.set(position);
            return true;
        }

        @Override
        public boolean contains(AnyObjectId objectId) {
            int position = BitmapIndexImpl.this.findPosition(objectId);
            return 0 <= position && this.bitset.contains(position);
        }

        @Override
        public void remove(AnyObjectId objectId) {
            int position = BitmapIndexImpl.this.findPosition(objectId);
            if (0 <= position) {
                this.bitset.remove(position);
            }
        }

        @Override
        public CompressedBitmapBuilder or(BitmapIndex.Bitmap other) {
            if (BitmapIndexImpl.this.isSameCompressedBitmap(other)) {
                this.bitset.or(((CompressedBitmap)other).bitmap);
            } else if (BitmapIndexImpl.this.isSameCompressedBitmapBuilder(other)) {
                CompressedBitmapBuilder b = (CompressedBitmapBuilder)other;
                this.bitset.or(b.bitset.combine());
            } else {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        public CompressedBitmapBuilder andNot(BitmapIndex.Bitmap other) {
            if (BitmapIndexImpl.this.isSameCompressedBitmap(other)) {
                this.bitset.andNot(((CompressedBitmap)other).bitmap);
            } else if (BitmapIndexImpl.this.isSameCompressedBitmapBuilder(other)) {
                CompressedBitmapBuilder b = (CompressedBitmapBuilder)other;
                this.bitset.andNot(b.bitset.combine());
            } else {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        public CompressedBitmapBuilder xor(BitmapIndex.Bitmap other) {
            if (BitmapIndexImpl.this.isSameCompressedBitmap(other)) {
                this.bitset.xor(((CompressedBitmap)other).bitmap);
            } else if (BitmapIndexImpl.this.isSameCompressedBitmapBuilder(other)) {
                CompressedBitmapBuilder b = (CompressedBitmapBuilder)other;
                this.bitset.xor(b.bitset.combine());
            } else {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        public CompressedBitmap build() {
            return new CompressedBitmap(this.bitset.combine());
        }

        @Override
        public Iterator<BitmapObject> iterator() {
            return this.build().iterator();
        }

        @Override
        public int cardinality() {
            return this.bitset.combine().cardinality();
        }

        @Override
        public boolean removeAllOrNone(PackBitmapIndex index) {
            if (!BitmapIndexImpl.this.packIndex.equals(index)) {
                return false;
            }
            EWAHCompressedBitmap curr = this.bitset.combine().xor(BitmapIndexImpl.ones(BitmapIndexImpl.this.indexObjectCount));
            IntIterator ii = curr.intIterator();
            if (ii.hasNext() && ii.next() < BitmapIndexImpl.this.indexObjectCount) {
                return false;
            }
            this.bitset = new ComboBitset(curr);
            return true;
        }

        private BitmapIndexImpl getBitmapIndex() {
            return BitmapIndexImpl.this;
        }
    }

    private static final class MutableBitmapIndex {
        private final ObjectIdOwnerMap<MutableEntry> revMap = new ObjectIdOwnerMap();
        private final BlockList<MutableEntry> revList = new BlockList();

        private MutableBitmapIndex() {
        }

        int findPosition(AnyObjectId objectId) {
            MutableEntry entry = this.revMap.get(objectId);
            if (entry == null) {
                return -1;
            }
            return entry.position;
        }

        MutableEntry getObject(int position) {
            try {
                MutableEntry entry = this.revList.get(position);
                if (entry == null) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().objectNotFound, String.valueOf(position)));
                }
                return entry;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        int addObject(AnyObjectId objectId, int type) {
            MutableEntry entry = new MutableEntry(objectId, type, this.revList.size());
            this.revList.add(entry);
            this.revMap.add(entry);
            return entry.position;
        }
    }

    private static final class MutableEntry
    extends ObjectIdOwnerMap.Entry {
        private final int type;
        private final int position;

        MutableEntry(AnyObjectId objectId, int type, int position) {
            super(objectId);
            this.type = type;
            this.position = position;
        }
    }
}

