/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.WebContainerConstants;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.util.ConversionUtil;
import org.ops4j.pax.web.service.spi.util.Path;

public class FilterModel
extends Model {
    private static final Set<String> VALID_DISPATCHER_VALUES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("request");
            this.add("forward");
            this.add("include");
            this.add("error");
        }
    };
    private final Filter filter;
    private final String[] urlPatterns;
    private final String[] servletNames;
    private final Map<String, String> initParams;
    private final String name;
    private final Set<String> dispatcher = new HashSet<String>();

    public FilterModel(ContextModel contextModel, Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParameter) {
        super(contextModel);
        NullArgumentException.validateNotNull(filter, "Filter");
        if (urlPatterns == null && servletNames == null) {
            throw new IllegalArgumentException("Registered filter must have at least one url pattern or servlet name mapping");
        }
        this.filter = filter;
        this.urlPatterns = Path.normalizePatterns(urlPatterns);
        this.servletNames = servletNames;
        this.initParams = ConversionUtil.convertToMap(initParameter);
        String name = this.initParams.get("filter-name");
        if (name == null) {
            name = this.getId();
        }
        this.name = name;
        this.setupDispatcher();
    }

    private void setupDispatcher() {
        String dispatches = this.initParams.get(WebContainerConstants.FILTER_MAPPING_DISPATCHER);
        if (dispatches != null && dispatches.trim().length() > 0) {
            if (dispatches.indexOf(",") > -1) {
                StringTokenizer tok = new StringTokenizer(dispatches.trim(), ",");
                while (tok.hasMoreTokens()) {
                    String element = tok.nextToken();
                    if (element == null || element.trim().length() <= 0) continue;
                    if (VALID_DISPATCHER_VALUES.contains(element.trim().toLowerCase())) {
                        this.dispatcher.add(element.trim());
                        continue;
                    }
                    throw new IllegalArgumentException("Incorrect value of dispatcher " + element.trim());
                }
            } else if (VALID_DISPATCHER_VALUES.contains(dispatches.trim().toLowerCase())) {
                this.dispatcher.add(dispatches.trim());
            } else {
                throw new IllegalArgumentException("Incorrect value of dispatcher " + dispatches.trim());
            }
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public String[] getDispatcher() {
        return this.dispatcher.toArray(new String[this.dispatcher.size()]);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getId() + ",urlPatterns=" + Arrays.toString(this.urlPatterns) + ",servletNames=" + Arrays.toString(this.servletNames) + ",filter=" + this.filter + ",context=" + this.getContextModel() + "}";
    }
}

