/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.Collection;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.osgi.BundlesCommand;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="osgi", name="classes", description="Displays list of classes contained in bundles")
public class Classes
extends BundlesCommand {
    @Option(name="-a", aliases={"--display-all-files"}, description="List all classes and files in bundles", required=false, multiValued=false)
    boolean displayAllFiles;

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        for (Bundle bundle : bundles) {
            this.printResources(bundle);
        }
    }

    protected void printResources(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            Collection resources = null;
            resources = this.displayAllFiles ? wiring.listResources("/", null, 1) : wiring.listResources("/", "*class", 1);
            if (resources.size() > 0) {
                System.out.println("\n" + Util.getBundleName(bundle));
            }
            for (String resource : resources) {
                System.out.println(resource);
            }
        } else {
            System.out.println("Bundle " + bundle.getBundleId() + " is not resolved");
        }
    }
}

