/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class CamelThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    private final CamelContext camelContext;
    private final Object source;
    private final String name;

    public CamelThreadPoolTaskScheduler(CamelContext camelContext, Object source, String name) {
        this.camelContext = camelContext;
        this.source = source;
        this.name = name;
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return this.camelContext.getExecutorServiceManager().newScheduledThreadPool(this.source, this.name, poolSize);
    }

    public void shutdown() {
        this.camelContext.getExecutorServiceManager().shutdownNow((ExecutorService)this.getScheduledExecutor());
    }
}

