/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.reflect.BeanArgumentImpl;
import org.apache.aries.blueprint.reflect.BeanPropertyImpl;
import org.apache.aries.blueprint.reflect.ComponentMetadataImpl;
import org.apache.aries.blueprint.reflect.MetadataUtil;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetadataImpl
extends ComponentMetadataImpl
implements MutableBeanMetadata {
    private String className;
    private String initMethod;
    private String destroyMethod;
    private List<BeanArgument> arguments;
    private List<BeanProperty> properties;
    private int initialization;
    private String factoryMethod;
    private Target factoryComponent;
    private QName scope;
    private Class runtimeClass;
    private boolean processor;
    private boolean fieldInjection;

    public BeanMetadataImpl() {
        this.fieldInjection = false;
    }

    public BeanMetadataImpl(BeanMetadata source) {
        super((ComponentMetadata)source);
        this.className = source.getClassName();
        this.initMethod = source.getInitMethod();
        this.destroyMethod = source.getDestroyMethod();
        for (BeanArgument argument : source.getArguments()) {
            this.addArgument(new BeanArgumentImpl(argument));
        }
        for (BeanProperty property : source.getProperties()) {
            this.addProperty(new BeanPropertyImpl(property));
        }
        this.initialization = source.getActivation();
        this.factoryMethod = source.getFactoryMethod();
        this.factoryComponent = MetadataUtil.cloneTarget(source.getFactoryComponent());
        this.scope = source.getScope() != null ? QName.valueOf(source.getScope()) : null;
        this.dependsOn = new ArrayList(source.getDependsOn());
        if (source instanceof ExtendedBeanMetadata) {
            this.runtimeClass = ((ExtendedBeanMetadata)source).getRuntimeClass();
            this.fieldInjection = ((ExtendedBeanMetadata)source).getFieldInjection();
        } else {
            this.fieldInjection = false;
        }
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    public String getInitMethod() {
        return this.initMethod;
    }

    @Override
    public void setInitMethod(String initMethodName) {
        this.initMethod = initMethodName;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    @Override
    public void setDestroyMethod(String destroyMethodName) {
        this.destroyMethod = destroyMethodName;
    }

    public List<BeanArgument> getArguments() {
        if (this.arguments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.arguments);
    }

    public void setArguments(List<BeanArgument> arguments) {
        this.arguments = arguments != null ? new ArrayList<BeanArgument>(arguments) : null;
    }

    @Override
    public void addArgument(BeanArgument argument) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<BeanArgument>();
        }
        this.arguments.add(argument);
    }

    @Override
    public BeanArgument addArgument(Metadata value, String valueType, int index) {
        BeanArgumentImpl arg = new BeanArgumentImpl(value, valueType, index);
        this.addArgument(arg);
        return arg;
    }

    @Override
    public void removeArgument(BeanArgument argument) {
        if (this.arguments != null) {
            this.arguments.remove(argument);
        }
    }

    public List<BeanProperty> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperties(List<BeanProperty> properties) {
        this.properties = properties != null ? new ArrayList<BeanProperty>(properties) : null;
    }

    @Override
    public void addProperty(BeanProperty property) {
        if (this.properties == null) {
            this.properties = new ArrayList<BeanProperty>();
        }
        this.properties.add(property);
    }

    @Override
    public BeanProperty addProperty(String name, Metadata value) {
        BeanPropertyImpl prop = new BeanPropertyImpl(name, value);
        this.addProperty(prop);
        return prop;
    }

    @Override
    public void removeProperty(BeanProperty property) {
        if (this.properties != null) {
            this.properties.remove(property);
        }
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void setFactoryMethod(String factoryMethodName) {
        this.factoryMethod = factoryMethodName;
    }

    public Target getFactoryComponent() {
        return this.factoryComponent;
    }

    @Override
    public void setFactoryComponent(Target factoryComponent) {
        this.factoryComponent = factoryComponent;
    }

    public String getScope() {
        return this.scope != null ? this.scope.toString() : null;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope != null ? QName.valueOf(scope) : null;
    }

    public Class getRuntimeClass() {
        return this.runtimeClass;
    }

    @Override
    public void setRuntimeClass(Class runtimeClass) {
        this.runtimeClass = runtimeClass;
    }

    @Override
    public boolean isProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(boolean processor) {
        this.processor = processor;
    }

    @Override
    public boolean getFieldInjection() {
        return this.fieldInjection;
    }

    @Override
    public void setFieldInjection(boolean fieldInjection) {
        this.fieldInjection = fieldInjection;
    }

    public String toString() {
        return "BeanMetadata[id='" + this.id + '\'' + ", initialization=" + this.initialization + ", dependsOn=" + this.dependsOn + ", className='" + this.className + '\'' + ", initMethodName='" + this.initMethod + '\'' + ", destroyMethodName='" + this.destroyMethod + '\'' + ", arguments=" + this.arguments + ", properties=" + this.properties + ", factoryMethodName='" + this.factoryMethod + '\'' + ", factoryComponent=" + this.factoryComponent + ", scope='" + this.scope + '\'' + ", runtimeClass=" + this.runtimeClass + ", fieldInjection=" + this.fieldInjection + ']';
    }
}

