/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.BindMethods;
import org.apache.felix.scr.impl.helper.DeactivateMethod;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;

public class ComponentMethods {
    private ActivateMethod m_activateMethod;
    private ModifiedMethod m_modifiedMethod;
    private DeactivateMethod m_deactivateMethod;
    private final Map bindMethodMap = new HashMap();

    public synchronized void initComponentMethods(ComponentMetadata componentMetadata, Class implementationObjectClass) {
        if (this.m_activateMethod != null) {
            return;
        }
        boolean isDS11 = componentMetadata.isDS11();
        boolean isDS12Felix = componentMetadata.isDS12Felix();
        this.m_activateMethod = new ActivateMethod(componentMetadata.getActivate(), componentMetadata.isActivateDeclared(), implementationObjectClass, isDS11, isDS12Felix);
        this.m_deactivateMethod = new DeactivateMethod(componentMetadata.getDeactivate(), componentMetadata.isDeactivateDeclared(), implementationObjectClass, isDS11, isDS12Felix);
        this.m_modifiedMethod = new ModifiedMethod(componentMetadata.getModified(), implementationObjectClass, isDS11, isDS12Felix);
        for (ReferenceMetadata referenceMetadata : componentMetadata.getDependencies()) {
            String refName = referenceMetadata.getName();
            BindMethods bindMethods = new BindMethods(referenceMetadata, implementationObjectClass, isDS11, isDS12Felix);
            this.bindMethodMap.put(refName, bindMethods);
        }
    }

    public ActivateMethod getActivateMethod() {
        return this.m_activateMethod;
    }

    public DeactivateMethod getDeactivateMethod() {
        return this.m_deactivateMethod;
    }

    public ModifiedMethod getModifiedMethod() {
        return this.m_modifiedMethod;
    }

    public BindMethods getBindMethods(String refName) {
        return (BindMethods)this.bindMethodMap.get(refName);
    }
}

