/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.extender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtender
implements BundleActivator,
BundleTrackerCustomizer,
SynchronousBundleListener {
    private final ConcurrentMap<Bundle, Extension> extensions = new ConcurrentHashMap<Bundle, Extension>();
    private final ConcurrentMap<Bundle, FutureTask> destroying = new ConcurrentHashMap<Bundle, FutureTask>();
    private volatile boolean stopping;
    private volatile boolean stopped;
    private boolean synchronous;
    private boolean preemptiveShutdown;
    private BundleContext context;
    private ExecutorService executors;
    private BundleTracker tracker;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isPreemptiveShutdown() {
        return this.preemptiveShutdown;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public ExecutorService getExecutors() {
        return this.executors;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void setPreemptiveShutdown(boolean preemptiveShutdown) {
        this.preemptiveShutdown = preemptiveShutdown;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.context.addBundleListener((BundleListener)this);
        this.tracker = new BundleTracker(this.context, 40, this);
        if (!this.synchronous) {
            this.executors = this.createExecutor();
        }
        this.doStart();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopping = true;
        while (!this.extensions.isEmpty()) {
            Collection<Bundle> toDestroy = this.chooseBundlesToDestroy(this.extensions.keySet());
            if (toDestroy == null || toDestroy.isEmpty()) {
                toDestroy = new ArrayList(this.extensions.keySet());
            }
            for (Bundle bundle : toDestroy) {
                this.destroyExtension(bundle);
            }
        }
        this.doStop();
        if (this.executors != null) {
            this.executors.shutdown();
            try {
                this.executors.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executors = null;
        }
        this.stopped = true;
    }

    protected void doStart() throws Exception {
        this.startTracking();
    }

    protected void doStop() throws Exception {
        this.stopTracking();
    }

    protected void startTracking() {
        this.tracker.open();
    }

    protected void stopTracking() {
        this.tracker.close();
    }

    protected ExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(3);
    }

    protected Collection<Bundle> chooseBundlesToDestroy(Set<Bundle> bundles) {
        return null;
    }

    public void bundleChanged(BundleEvent event) {
        if (this.stopped) {
            return;
        }
        Bundle bundle = event.getBundle();
        if (bundle.getState() != 32 && bundle.getState() != 8 && bundle != this.context.getBundle()) {
            this.destroyExtension(bundle);
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        String activationPolicyHeader;
        if (this.context.getBundle(0L).equals(bundle) && bundle.getState() == 16 && this.preemptiveShutdown) {
            try {
                this.stop(this.context);
            }
            catch (Exception e) {
                this.error("Error while performing preemptive shutdown", e);
            }
            return;
        }
        if (bundle.getState() != 32 && bundle.getState() != 8) {
            if (bundle != this.context.getBundle()) {
                this.destroyExtension(bundle);
            }
            return;
        }
        if (this.stopping) {
            return;
        }
        if (!(bundle.getState() != 8 || (activationPolicyHeader = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy"))) {
            return;
        }
        this.createExtension(bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.destroyExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExtension(final Bundle bundle) {
        try {
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                return;
            }
            final Extension extension = this.doCreateExtension(bundle);
            if (extension == null) {
                return;
            }
            ConcurrentMap<Bundle, Extension> concurrentMap = this.extensions;
            synchronized (concurrentMap) {
                if (this.extensions.putIfAbsent(bundle, extension) != null) {
                    return;
                }
            }
            if (this.synchronous) {
                this.debug(bundle, "Starting extension synchronously");
                extension.start();
            } else {
                this.debug(bundle, "Scheduling asynchronous start of extension");
                this.getExecutors().submit(new Runnable(){

                    public void run() {
                        try {
                            extension.start();
                        }
                        catch (Exception e) {
                            AbstractExtender.this.warn(bundle, "Error starting extension", e);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.warn(bundle, "Error while creating extension", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyExtension(final Bundle bundle) {
        FutureTask<Object> future;
        ConcurrentMap<Bundle, Extension> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            this.debug(bundle, "Starting destruction process");
            future = (FutureTask<Object>)this.destroying.get(bundle);
            if (future == null) {
                final Extension extension = (Extension)this.extensions.remove(bundle);
                if (extension != null) {
                    this.debug(bundle, "Scheduling extension destruction");
                    future = new FutureTask<Object>(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            AbstractExtender.this.debug(bundle, "Destroying extension");
                            try {
                                extension.destroy();
                            }
                            catch (Exception e) {
                                AbstractExtender.this.warn(bundle, "Error while destroying extension", e);
                            }
                            finally {
                                AbstractExtender.this.debug(bundle, "Finished destroying extension");
                                ConcurrentMap concurrentMap = AbstractExtender.this.extensions;
                                synchronized (concurrentMap) {
                                    AbstractExtender.this.destroying.remove(bundle);
                                }
                            }
                        }
                    }, null);
                    this.destroying.put(bundle, future);
                } else {
                    this.debug(bundle, "Not an extended bundle or destruction of extension already finished");
                }
            } else {
                this.debug(bundle, "Destruction already scheduled");
            }
        }
        if (future != null) {
            try {
                this.debug(bundle, "Waiting for extension destruction");
                future.run();
                future.get();
            }
            catch (Throwable t) {
                this.warn(bundle, "Error while destroying extension", t);
            }
        }
    }

    protected abstract Extension doCreateExtension(Bundle var1) throws Exception;

    protected abstract void debug(Bundle var1, String var2);

    protected abstract void warn(Bundle var1, String var2, Throwable var3);

    protected abstract void error(String var1, Throwable var2);
}

