/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BroadcastOperationResponse
extends ActionResponse {
    private int totalShards;
    private int successfulShards;
    private int failedShards;
    private List<ShardOperationFailedException> shardFailures = ImmutableList.of();

    protected BroadcastOperationResponse() {
    }

    protected BroadcastOperationResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures;
        if (shardFailures == null) {
            this.shardFailures = ImmutableList.of();
        }
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int failedShards() {
        return this.failedShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public List<? extends ShardOperationFailedException> shardFailures() {
        if (this.shardFailures == null) {
            return ImmutableList.of();
        }
        return this.shardFailures;
    }

    public List<ShardOperationFailedException> getShardFailures() {
        return this.shardFailures;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size = in.readVInt();
        if (size > 0) {
            this.shardFailures = new ArrayList<ShardOperationFailedException>(size);
            for (int i = 0; i < size; ++i) {
                this.shardFailures.add(DefaultShardOperationFailedException.readShardOperationFailed(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.shardFailures.size());
        for (ShardOperationFailedException exp : this.shardFailures) {
            exp.writeTo(out);
        }
    }
}

