/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.elasticsearch.common.Hex;

public class Digest {
    private static final int STREAM_BUFFER_LENGTH = 16384;
    private static final Charset Charset_UTF8 = Charset.forName("UTF8");
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final NullDigest NULL_DIGEST = new NullDigest("null");

    private static byte[] digest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[16384];
        int read = data.read(buffer, 0, 16384);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 16384);
        }
        return digest.digest();
    }

    private static byte[] getBytesUtf8(String data) {
        return data.getBytes(Charset_UTF8);
    }

    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static MessageDigest getMd5Digest() {
        return Digest.getDigest("MD5");
    }

    private static MessageDigest getSha256Digest() {
        return Digest.getDigest("SHA-256");
    }

    private static MessageDigest getSha384Digest() {
        return Digest.getDigest("SHA-384");
    }

    private static MessageDigest getSha512Digest() {
        return Digest.getDigest("SHA-512");
    }

    private static MessageDigest getShaDigest() {
        return Digest.getDigest("SHA");
    }

    public static byte[] md5(byte[] data) {
        return Digest.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        return Digest.digest(Digest.getMd5Digest(), data);
    }

    public static byte[] md5(String data) {
        return Digest.md5(Digest.getBytesUtf8(data));
    }

    public static String md5Hex(byte[] data) {
        return Hex.encodeHexString(Digest.md5(data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(Digest.md5(data));
    }

    public static String md5Hex(String data) {
        return Hex.encodeHexString(Digest.md5(data));
    }

    public static byte[] md5HexToByteArray(String md5Hex) {
        return md5Hex.getBytes(US_ASCII);
    }

    public static String md5HexFromByteArray(byte[] data) {
        return new String(data, 0, 32, US_ASCII);
    }

    public static byte[] sha(byte[] data) {
        return Digest.getShaDigest().digest(data);
    }

    public static byte[] sha(InputStream data) throws IOException {
        return Digest.digest(Digest.getShaDigest(), data);
    }

    public static byte[] sha(String data) {
        return Digest.sha(Digest.getBytesUtf8(data));
    }

    public static byte[] sha256(byte[] data) {
        return Digest.getSha256Digest().digest(data);
    }

    public static byte[] sha256(InputStream data) throws IOException {
        return Digest.digest(Digest.getSha256Digest(), data);
    }

    public static byte[] sha256(String data) {
        return Digest.sha256(Digest.getBytesUtf8(data));
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encodeHexString(Digest.sha256(data));
    }

    public static String sha256Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(Digest.sha256(data));
    }

    public static String sha256Hex(String data) {
        return Hex.encodeHexString(Digest.sha256(data));
    }

    public static byte[] sha384(byte[] data) {
        return Digest.getSha384Digest().digest(data);
    }

    public static byte[] sha384(InputStream data) throws IOException {
        return Digest.digest(Digest.getSha384Digest(), data);
    }

    public static byte[] sha384(String data) {
        return Digest.sha384(Digest.getBytesUtf8(data));
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encodeHexString(Digest.sha384(data));
    }

    public static String sha384Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(Digest.sha384(data));
    }

    public static String sha384Hex(String data) {
        return Hex.encodeHexString(Digest.sha384(data));
    }

    public static byte[] sha512(byte[] data) {
        return Digest.getSha512Digest().digest(data);
    }

    public static byte[] sha512(InputStream data) throws IOException {
        return Digest.digest(Digest.getSha512Digest(), data);
    }

    public static byte[] sha512(String data) {
        return Digest.sha512(Digest.getBytesUtf8(data));
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encodeHexString(Digest.sha512(data));
    }

    public static String sha512Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(Digest.sha512(data));
    }

    public static String sha512Hex(String data) {
        return Hex.encodeHexString(Digest.sha512(data));
    }

    public static String shaHex(byte[] data) {
        return Hex.encodeHexString(Digest.sha(data));
    }

    public static String shaHex(InputStream data) throws IOException {
        return Hex.encodeHexString(Digest.sha(data));
    }

    public static String shaHex(String data) {
        return Hex.encodeHexString(Digest.sha(data));
    }

    private static final class NullDigest
    extends MessageDigest {
        private NullDigest(String algorithm) {
            super(algorithm);
        }

        @Override
        protected void engineUpdate(byte input) {
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
        }

        @Override
        protected byte[] engineDigest() {
            return null;
        }

        @Override
        protected void engineReset() {
        }
    }
}

