/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.lucene.FieldBuilder;
import org.elasticsearch.common.lucene.uid.UidField;

public class DocumentBuilder {
    public static final Document EMPTY = new Document();
    private final Document document = new Document();

    public static DocumentBuilder doc() {
        return new DocumentBuilder();
    }

    public static Fieldable uidField(String value) {
        return DocumentBuilder.uidField(value, 0L);
    }

    public static Fieldable uidField(String value, long version) {
        return new UidField("_uid", value, version);
    }

    public static FieldBuilder field(String name, String value) {
        return DocumentBuilder.field(name, value, Field.Store.YES, Field.Index.ANALYZED);
    }

    public static FieldBuilder field(String name, String value, Field.Store store, Field.Index index) {
        return new FieldBuilder(name, value, store, index);
    }

    public static FieldBuilder field(String name, String value, Field.Store store, Field.Index index, Field.TermVector termVector) {
        return new FieldBuilder(name, value, store, index, termVector);
    }

    public static FieldBuilder field(String name, byte[] value, Field.Store store) {
        return new FieldBuilder(name, value, store);
    }

    public static FieldBuilder field(String name, byte[] value, int offset, int length, Field.Store store) {
        return new FieldBuilder(name, value, offset, length, store);
    }

    private DocumentBuilder() {
    }

    public DocumentBuilder boost(float boost) {
        this.document.setBoost(boost);
        return this;
    }

    public DocumentBuilder add(Fieldable field) {
        this.document.add(field);
        return this;
    }

    public DocumentBuilder add(FieldBuilder fieldBuilder) {
        this.document.add(fieldBuilder.build());
        return this;
    }

    public Document build() {
        return this.document;
    }
}

