/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.FixedBitDocSet;
import org.elasticsearch.common.lucene.docset.OpenBitDocSet;

public class DocSets {
    public static FixedBitSet createFixedBitSet(DocIdSetIterator disi, int numBits) throws IOException {
        int doc;
        FixedBitSet set = new FixedBitSet(numBits);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            set.set(doc);
        }
        return set;
    }

    public static void or(FixedBitSet into, DocIdSet other) throws IOException {
        if (other == null) {
            return;
        }
        if (other instanceof FixedBitSet) {
            into.or((FixedBitSet)other);
        } else if (other instanceof FixedBitDocSet) {
            into.or(((FixedBitDocSet)other).set());
        } else {
            DocIdSetIterator disi = other.iterator();
            if (disi != null) {
                into.or(disi);
            }
        }
    }

    public static void and(FixedBitSet into, DocIdSet other) throws IOException {
        if (other instanceof FixedBitDocSet) {
            other = ((FixedBitDocSet)other).set();
        }
        if (other instanceof FixedBitSet) {
            into.and((FixedBitSet)other);
        } else if (other == null) {
            into.clear(0, into.length());
        } else {
            DocIdSetIterator disi = other.iterator();
            if (disi == null) {
                into.clear(0, into.length());
            } else {
                into.and(disi);
            }
        }
    }

    public static void andNot(FixedBitSet into, DocIdSet other) throws IOException {
        if (other == null) {
            return;
        }
        if (other instanceof FixedBitDocSet) {
            other = ((FixedBitDocSet)other).set();
        }
        if (other instanceof FixedBitSet) {
            into.andNot((FixedBitSet)other);
        } else {
            DocIdSetIterator disi = other.iterator();
            if (disi != null) {
                into.andNot(disi);
            }
        }
    }

    public static DocSet convert(IndexReader reader, DocIdSet docIdSet) throws IOException {
        if (docIdSet == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (docIdSet instanceof DocSet) {
            return (DocSet)docIdSet;
        }
        if (docIdSet instanceof FixedBitSet) {
            return new FixedBitDocSet((FixedBitSet)docIdSet);
        }
        if (docIdSet instanceof OpenBitSet) {
            return new OpenBitDocSet((OpenBitSet)docIdSet);
        }
        DocIdSetIterator it = docIdSet.iterator();
        return it == null ? DocSet.EMPTY_DOC_SET : new FixedBitDocSet(DocSets.createFixedBitSet(it, reader.maxDoc()));
    }

    public static DocSet cacheable(IndexReader reader, @Nullable DocIdSet set) throws IOException {
        if (set == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (set == DocIdSet.EMPTY_DOCIDSET) {
            return DocSet.EMPTY_DOC_SET;
        }
        DocIdSetIterator it = set.iterator();
        if (it == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        int doc = it.nextDoc();
        if (doc == Integer.MAX_VALUE) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (set.isCacheable() && set instanceof DocSet) {
            return (DocSet)set;
        }
        if (set instanceof FixedBitSet) {
            return new FixedBitDocSet((FixedBitSet)set);
        }
        if (set instanceof OpenBitSet) {
            return new OpenBitDocSet((OpenBitSet)set);
        }
        FixedBitSet fixedBitSet = new FixedBitSet(reader.maxDoc());
        fixedBitSet.set(doc);
        while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
            fixedBitSet.set(doc);
        }
        return new FixedBitDocSet(fixedBitSet);
    }

    private DocSets() {
    }
}

