/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class StopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<?> stopWords;
    private final boolean ignoreCase;
    private final boolean enablePositionIncrements;

    @Inject
    public StopTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.stopWords = Analysis.parseStopWords(env, settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.version);
        this.ignoreCase = settings.getAsBoolean("ignore_case", false);
        this.enablePositionIncrements = settings.getAsBoolean("enable_position_increments", this.version.onOrAfter(Version.LUCENE_29));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        StopFilter filter = new StopFilter(this.version, tokenStream, this.stopWords, this.ignoreCase);
        filter.setEnablePositionIncrements(this.enablePositionIncrements);
        return filter;
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }
}

