/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.lookup.SourceLookup;

public class GetResult
implements Streamable,
Iterable<GetField>,
ToXContent {
    private String index;
    private String type;
    private String id;
    private long version;
    private boolean exists;
    private Map<String, GetField> fields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;
    private byte[] sourceAsBytes;

    GetResult() {
    }

    public GetResult(String index, String type, String id, long version, boolean exists, BytesReference source, Map<String, GetField> fields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.version = version;
        this.exists = exists;
        this.source = source;
        this.fields = fields;
        if (this.fields == null) {
            this.fields = ImmutableMap.of();
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isExists() {
        return this.exists;
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = this.sourceRef().toBytes();
        return this.sourceAsBytes;
    }

    public BytesReference sourceRef() {
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticSearchParseException("failed to decompress source", e);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticSearchParseException("failed to convert source to a json string");
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticSearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    public Map<String, GetField> fields() {
        return this.fields;
    }

    public Map<String, GetField> getFields() {
        return this.fields;
    }

    public GetField field(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<GetField> iterator() {
        if (this.fields == null) {
            return Iterators.emptyIterator();
        }
        return this.fields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.EXISTS, this.exists);
        if (this.source != null) {
            RestXContentBuilder.restDocumentSource(this.source, builder, params);
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            builder.startObject(Fields.FIELDS);
            for (GetField field : this.fields.values()) {
                if (field.values().isEmpty()) continue;
                if (field.values().size() == 1) {
                    builder.field(field.name(), field.values().get(0));
                    continue;
                }
                builder.field(field.name());
                builder.startArray();
                for (Object value : field.values()) {
                    builder.value(value);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.exists()) {
            builder.startObject();
            builder.field(Fields._INDEX, this.index);
            builder.field(Fields._TYPE, this.type);
            builder.field(Fields._ID, this.id);
            builder.field(Fields.EXISTS, false);
            builder.endObject();
        } else {
            builder.startObject();
            builder.field(Fields._INDEX, this.index);
            builder.field(Fields._TYPE, this.type);
            builder.field(Fields._ID, this.id);
            if (this.version != -1L) {
                builder.field(Fields._VERSION, this.version);
            }
            this.toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public static GetResult readGetResult(StreamInput in) throws IOException {
        GetResult result = new GetResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readUTF();
        this.type = in.readOptionalUTF();
        this.id = in.readUTF();
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            int size;
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            if ((size = in.readVInt()) == 0) {
                this.fields = ImmutableMap.of();
            } else {
                this.fields = Maps.newHashMapWithExpectedSize(size);
                for (int i = 0; i < size; ++i) {
                    GetField field = GetField.readGetField(in);
                    this.fields.put(field.name(), field);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeOptionalUTF(this.type);
        out.writeUTF(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.size());
                for (GetField field : this.fields.values()) {
                    field.writeTo(out);
                }
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString EXISTS = new XContentBuilderString("exists");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");

        Fields() {
        }
    }
}

