/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public class UidFilter
extends Filter {
    final Term[] uids;
    private final BloomCache bloomCache;

    public UidFilter(Collection<String> types, List<String> ids, BloomCache bloomCache) {
        this.bloomCache = bloomCache;
        this.uids = new Term[types.size() * ids.size()];
        int i = 0;
        for (String type : types) {
            for (String id : ids) {
                this.uids[i++] = UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(type, id));
            }
        }
        if (this.uids.length > 1) {
            Arrays.sort(this.uids);
        }
    }

    public Term[] getTerms() {
        return this.uids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        BloomFilter filter = this.bloomCache.filter(reader, UidFieldMapper.NAME, true);
        FixedBitSet set = null;
        TermDocs td = null;
        UnicodeUtil.UTF8Result utf8 = new UnicodeUtil.UTF8Result();
        try {
            for (Term uid : this.uids) {
                Unicode.fromStringAsUtf8(uid.text(), utf8);
                if (!filter.isPresent(utf8.result, 0, utf8.length)) continue;
                if (td == null) {
                    td = reader.termDocs();
                }
                td.seek(uid);
                while (td.next()) {
                    if (set == null) {
                        set = new FixedBitSet(reader.maxDoc());
                    }
                    set.set(td.doc());
                }
            }
        }
        finally {
            if (td != null) {
                td.close();
            }
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UidFilter uidFilter = (UidFilter)o;
        return Arrays.equals(this.uids, uidFilter.uids);
    }

    public int hashCode() {
        return Arrays.hashCode(this.uids);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Term term : this.uids) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(term);
        }
        return builder.toString();
    }
}

