/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class JvmInfo
implements Streamable,
Serializable,
ToXContent {
    private static JvmInfo INSTANCE;
    long pid = -1L;
    String version = "";
    String vmName = "";
    String vmVersion = "";
    String vmVendor = "";
    long startTime = -1L;
    Mem mem;
    String[] inputArguments;
    String bootClassPath;
    String classPath;
    Map<String, String> systemProperties;

    public static JvmInfo jvmInfo() {
        return INSTANCE;
    }

    private JvmInfo() {
    }

    public long pid() {
        return this.pid;
    }

    public long getPid() {
        return this.pid;
    }

    public String version() {
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public int versionAsInteger() {
        try {
            int i;
            String sVersion = "";
            for (i = 0; i < this.version.length() && (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.'); ++i) {
                if (this.version.charAt(i) == '.') continue;
                sVersion = sVersion + this.version.charAt(i);
            }
            if (i == 0) {
                return -1;
            }
            return Integer.parseInt(sVersion);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int versionUpdatePack() {
        try {
            int from;
            int i;
            String sVersion = "";
            for (i = 0; i < this.version.length() && (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.'); ++i) {
                if (this.version.charAt(i) == '.') continue;
                sVersion = sVersion + this.version.charAt(i);
            }
            if (i == 0) {
                return -1;
            }
            Integer.parseInt(sVersion);
            if (this.version.charAt(i) == '_') {
                from = ++i;
            } else if (this.version.charAt(i) == '-' && this.version.charAt(i + 1) == 'u') {
                from = i += 2;
            } else {
                return -1;
            }
            while (i < this.version.length() && (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.')) {
                ++i;
            }
            if (from == i) {
                return -1;
            }
            return Integer.parseInt(this.version.substring(from, i));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String vmName() {
        return this.vmName;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String vmVersion() {
        return this.vmVersion;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String vmVendor() {
        return this.vmVendor;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public long startTime() {
        return this.startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public String[] inputArguments() {
        return this.inputArguments;
    }

    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public String bootClassPath() {
        return this.bootClassPath;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String classPath() {
        return this.classPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public Map<String, String> systemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.JVM);
        builder.field(Fields.PID, this.pid);
        builder.field(Fields.VERSION, this.version);
        builder.field(Fields.VM_NAME, this.vmName);
        builder.field(Fields.VM_VERSION, this.vmVersion);
        builder.field(Fields.VM_VENDOR, this.vmVendor);
        builder.field(Fields.START_TIME, this.startTime);
        builder.startObject(Fields.MEM);
        builder.field(Fields.HEAP_INIT, this.mem.heapInit().toString());
        builder.field(Fields.HEAP_INIT_IN_BYTES, this.mem.heapInit);
        builder.field(Fields.HEAP_MAX, this.mem.heapMax().toString());
        builder.field(Fields.HEAP_MAX_IN_BYTES, this.mem.heapMax);
        builder.field(Fields.NON_HEAP_INIT, this.mem.nonHeapInit().toString());
        builder.field(Fields.NON_HEAP_INIT_IN_BYTES, this.mem.nonHeapInit);
        builder.field(Fields.NON_HEAP_MAX, this.mem.nonHeapMax().toString());
        builder.field(Fields.NON_HEAP_MAX_IN_BYTES, this.mem.nonHeapMax);
        builder.field(Fields.DIRECT_MAX, this.mem.directMemoryMax().toString());
        builder.field(Fields.DIRECT_MAX_IN_BYTES, this.mem.directMemoryMax().bytes());
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static JvmInfo readJvmInfo(StreamInput in) throws IOException {
        JvmInfo jvmInfo = new JvmInfo();
        jvmInfo.readFrom(in);
        return jvmInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.pid = in.readLong();
        this.version = in.readUTF();
        this.vmName = in.readUTF();
        this.vmVersion = in.readUTF();
        this.vmVendor = in.readUTF();
        this.startTime = in.readLong();
        this.inputArguments = new String[in.readInt()];
        for (int i = 0; i < this.inputArguments.length; ++i) {
            this.inputArguments[i] = in.readUTF();
        }
        this.bootClassPath = in.readUTF();
        this.classPath = in.readUTF();
        this.systemProperties = new HashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.systemProperties.put(in.readUTF(), in.readUTF());
        }
        this.mem = new Mem();
        this.mem.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pid);
        out.writeUTF(this.version);
        out.writeUTF(this.vmName);
        out.writeUTF(this.vmVersion);
        out.writeUTF(this.vmVendor);
        out.writeLong(this.startTime);
        out.writeInt(this.inputArguments.length);
        for (String inputArgument : this.inputArguments) {
            out.writeUTF(inputArgument);
        }
        out.writeUTF(this.bootClassPath);
        out.writeUTF(this.classPath);
        out.writeInt(this.systemProperties.size());
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
        this.mem.writeTo(out);
    }

    static {
        long pid;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        String xPid = runtimeMXBean.getName();
        try {
            xPid = xPid.split("@")[0];
            pid = Long.parseLong(xPid);
        }
        catch (Exception e) {
            pid = -1L;
        }
        JvmInfo info = new JvmInfo();
        info.pid = pid;
        info.startTime = runtimeMXBean.getStartTime();
        info.version = runtimeMXBean.getSystemProperties().get("java.version");
        info.vmName = runtimeMXBean.getVmName();
        info.vmVendor = runtimeMXBean.getVmVendor();
        info.vmVersion = runtimeMXBean.getVmVersion();
        (info.mem = new Mem()).heapInit = memoryMXBean.getHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getInit();
        info.mem.heapMax = memoryMXBean.getHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getMax();
        info.mem.nonHeapInit = memoryMXBean.getNonHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getNonHeapMemoryUsage().getInit();
        info.mem.nonHeapMax = memoryMXBean.getNonHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getNonHeapMemoryUsage().getMax();
        try {
            Class<?> vmClass = Class.forName("sun.misc.VM");
            info.mem.directMemoryMax = (Long)vmClass.getMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            // empty catch block
        }
        info.inputArguments = runtimeMXBean.getInputArguments().toArray(new String[runtimeMXBean.getInputArguments().size()]);
        info.bootClassPath = runtimeMXBean.getBootClassPath();
        info.classPath = runtimeMXBean.getClassPath();
        info.systemProperties = runtimeMXBean.getSystemProperties();
        INSTANCE = info;
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long heapInit = 0L;
        long heapMax = 0L;
        long nonHeapInit = 0L;
        long nonHeapMax = 0L;
        long directMemoryMax = 0L;

        Mem() {
        }

        public ByteSizeValue heapInit() {
            return new ByteSizeValue(this.heapInit);
        }

        public ByteSizeValue getHeapInit() {
            return this.heapInit();
        }

        public ByteSizeValue heapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public ByteSizeValue getHeapMax() {
            return this.heapMax();
        }

        public ByteSizeValue nonHeapInit() {
            return new ByteSizeValue(this.nonHeapInit);
        }

        public ByteSizeValue getNonHeapInit() {
            return this.nonHeapInit();
        }

        public ByteSizeValue nonHeapMax() {
            return new ByteSizeValue(this.nonHeapMax);
        }

        public ByteSizeValue getNonHeapMax() {
            return this.nonHeapMax();
        }

        public ByteSizeValue directMemoryMax() {
            return new ByteSizeValue(this.directMemoryMax);
        }

        public ByteSizeValue getDirectMemoryMax() {
            return this.directMemoryMax();
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.heapInit = in.readVLong();
            this.heapMax = in.readVLong();
            this.nonHeapInit = in.readVLong();
            this.nonHeapMax = in.readVLong();
            this.directMemoryMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapInit);
            out.writeVLong(this.heapMax);
            out.writeVLong(this.nonHeapInit);
            out.writeVLong(this.nonHeapMax);
            out.writeVLong(this.directMemoryMax);
        }
    }

    static final class Fields {
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString PID = new XContentBuilderString("pid");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");
        static final XContentBuilderString VM_NAME = new XContentBuilderString("vm_name");
        static final XContentBuilderString VM_VERSION = new XContentBuilderString("vm_version");
        static final XContentBuilderString VM_VENDOR = new XContentBuilderString("vm_vendor");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString HEAP_INIT = new XContentBuilderString("heap_init");
        static final XContentBuilderString HEAP_INIT_IN_BYTES = new XContentBuilderString("heap_init_in_bytes");
        static final XContentBuilderString HEAP_MAX = new XContentBuilderString("heap_max");
        static final XContentBuilderString HEAP_MAX_IN_BYTES = new XContentBuilderString("heap_max_in_bytes");
        static final XContentBuilderString NON_HEAP_INIT = new XContentBuilderString("non_heap_init");
        static final XContentBuilderString NON_HEAP_INIT_IN_BYTES = new XContentBuilderString("non_heap_init_in_bytes");
        static final XContentBuilderString NON_HEAP_MAX = new XContentBuilderString("non_heap_max");
        static final XContentBuilderString NON_HEAP_MAX_IN_BYTES = new XContentBuilderString("non_heap_max_in_bytes");
        static final XContentBuilderString DIRECT_MAX = new XContentBuilderString("direct_max");
        static final XContentBuilderString DIRECT_MAX_IN_BYTES = new XContentBuilderString("direct_max_in_bytes");

        Fields() {
        }
    }
}

