/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.AbstractRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class XContentRestResponse
extends AbstractRestResponse {
    private static final byte[] END_JSONP;
    private static ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>> prefixCache;
    private final UnicodeUtil.UTF8Result prefixUtf8Result;
    private final RestStatus status;
    private final XContentBuilder builder;

    public XContentRestResponse(RestRequest request, RestStatus status, XContentBuilder builder) throws IOException {
        this.builder = builder;
        this.status = status;
        this.prefixUtf8Result = XContentRestResponse.startJsonp(request);
    }

    public XContentBuilder builder() {
        return this.builder;
    }

    @Override
    public String contentType() {
        return this.builder.contentType().restContentType();
    }

    @Override
    public boolean contentThreadSafe() {
        return false;
    }

    @Override
    public byte[] content() throws IOException {
        return this.builder.bytes().array();
    }

    @Override
    public int contentLength() throws IOException {
        return this.builder.bytes().length();
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public byte[] prefixContent() {
        if (this.prefixUtf8Result != null) {
            return this.prefixUtf8Result.result;
        }
        return null;
    }

    @Override
    public int prefixContentLength() {
        if (this.prefixUtf8Result != null) {
            return this.prefixUtf8Result.length;
        }
        return 0;
    }

    @Override
    public byte[] suffixContent() {
        if (this.prefixUtf8Result != null) {
            return END_JSONP;
        }
        return null;
    }

    @Override
    public int suffixContentLength() {
        if (this.prefixUtf8Result != null) {
            return END_JSONP.length;
        }
        return 0;
    }

    private static UnicodeUtil.UTF8Result startJsonp(RestRequest request) {
        String callback = request.param("callback");
        if (callback == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result = prefixCache.get().get();
        UnicodeUtil.UTF16toUTF8(callback, 0, callback.length(), result);
        result.result[result.length] = 40;
        ++result.length;
        return result;
    }

    static {
        UnicodeUtil.UTF8Result U_END_JSONP = new UnicodeUtil.UTF8Result();
        UnicodeUtil.UTF16toUTF8(");", 0, ");".length(), U_END_JSONP);
        END_JSONP = new byte[U_END_JSONP.length];
        System.arraycopy(U_END_JSONP.result, 0, END_JSONP, 0, U_END_JSONP.length);
        prefixCache = new ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>>(){

            @Override
            protected ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result> initialValue() {
                return new ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>(new UnicodeUtil.UTF8Result());
            }
        };
    }
}

