/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.exists.types;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportTypesExistsAction
extends TransportMasterNodeOperationAction<TypesExistsRequest, TypesExistsResponse> {
    @Inject
    public TransportTypesExistsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/types/exists";
    }

    @Override
    protected TypesExistsRequest newRequest() {
        return new TypesExistsRequest();
    }

    @Override
    protected TypesExistsResponse newResponse() {
        return new TypesExistsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(TypesExistsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, request.indices());
    }

    @Override
    protected TypesExistsResponse masterOperation(TypesExistsRequest request, ClusterState state) throws ElasticSearchException {
        String[] concreteIndices = state.metaData().concreteIndices(request.indices(), request.ignoreIndices(), false);
        if (concreteIndices.length == 0) {
            return new TypesExistsResponse(false);
        }
        for (String concreteIndex : concreteIndices) {
            if (!state.metaData().hasConcreteIndex(concreteIndex)) {
                return new TypesExistsResponse(false);
            }
            ImmutableMap<String, MappingMetaData> mappings = state.metaData().getIndices().get(concreteIndex).mappings();
            if (mappings.isEmpty()) {
                return new TypesExistsResponse(false);
            }
            for (String type : request.types()) {
                if (mappings.containsKey(type)) continue;
                return new TypesExistsResponse(false);
            }
        }
        return new TypesExistsResponse(true);
    }
}

