/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportClientNodesService
extends AbstractComponent {
    private final TimeValue nodesSamplerInterval;
    private final long pingTimeout;
    private final ClusterName clusterName;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private volatile ImmutableList<DiscoveryNode> listedNodes = ImmutableList.of();
    private final Object transportMutex = new Object();
    private volatile ImmutableList<DiscoveryNode> nodes = ImmutableList.of();
    private final AtomicInteger tempNodeIdGenerator = new AtomicInteger();
    private final NodeSampler nodesSampler;
    private volatile ScheduledFuture nodesSamplerFuture;
    private final AtomicInteger randomNodeGenerator = new AtomicInteger();
    private final boolean ignoreClusterName;
    private volatile boolean closed;

    @Inject
    public TransportClientNodesService(Settings settings, ClusterName clusterName, TransportService transportService, ThreadPool threadPool) {
        super(settings);
        this.clusterName = clusterName;
        this.transportService = transportService;
        this.threadPool = threadPool;
        this.nodesSamplerInterval = this.componentSettings.getAsTime("nodes_sampler_interval", TimeValue.timeValueSeconds(5L));
        this.pingTimeout = this.componentSettings.getAsTime("ping_timeout", TimeValue.timeValueSeconds(5L)).millis();
        this.ignoreClusterName = this.componentSettings.getAsBoolean("ignore_cluster_name", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("node_sampler_interval[" + this.nodesSamplerInterval + "]", new Object[0]);
        }
        this.nodesSampler = this.componentSettings.getAsBoolean("sniff", false) != false ? new SniffNodesSampler() : new SimpleNodeSampler();
        this.nodesSamplerFuture = threadPool.schedule(this.nodesSamplerInterval, "generic", new ScheduledNodeSampler());
        transportService.throwConnectException(true);
    }

    public ImmutableList<TransportAddress> transportAddresses() {
        ImmutableList.Builder lstBuilder = ImmutableList.builder();
        for (DiscoveryNode listedNode : this.listedNodes) {
            lstBuilder.add(listedNode.address());
        }
        return lstBuilder.build();
    }

    public ImmutableList<DiscoveryNode> connectedNodes() {
        return this.nodes;
    }

    public ImmutableList<DiscoveryNode> listedNodes() {
        return this.listedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService addTransportAddresses(TransportAddress ... transportAddresses) {
        Object object = this.transportMutex;
        synchronized (object) {
            ArrayList<TransportAddress> filtered = Lists.newArrayListWithExpectedSize(transportAddresses.length);
            for (TransportAddress transportAddress : transportAddresses) {
                boolean found = false;
                for (DiscoveryNode otherNode : this.listedNodes) {
                    if (!otherNode.address().equals(transportAddress)) continue;
                    found = true;
                    this.logger.debug("address [{}] already exists with [{}], ignoring...", transportAddress, otherNode);
                    break;
                }
                if (found) continue;
                filtered.add(transportAddress);
            }
            if (filtered.isEmpty()) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.listedNodes());
            for (TransportAddress transportAddress : filtered) {
                DiscoveryNode node = new DiscoveryNode("#transport#-" + this.tempNodeIdGenerator.incrementAndGet(), transportAddress);
                this.logger.debug("adding address [{}]", node);
                builder.add(node);
            }
            this.listedNodes = builder.build();
        }
        this.nodesSampler.sample();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService removeTransportAddress(TransportAddress transportAddress) {
        Object object = this.transportMutex;
        synchronized (object) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DiscoveryNode otherNode : this.listedNodes) {
                if (!otherNode.address().equals(transportAddress)) {
                    builder.add(otherNode);
                    continue;
                }
                this.logger.debug("removing address [{}]", otherNode);
            }
            this.listedNodes = builder.build();
        }
        this.nodesSampler.sample();
        return this;
    }

    public <T> T execute(NodeCallback<T> callback) throws ElasticSearchException {
        ImmutableList<DiscoveryNode> nodes = this.nodes;
        if (nodes.isEmpty()) {
            throw new NoNodeAvailableException();
        }
        int index = this.randomNodeGenerator.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.randomNodeGenerator.set(0);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            DiscoveryNode node = (DiscoveryNode)nodes.get((index + i) % nodes.size());
            try {
                return callback.doWithNode(node);
            }
            catch (ElasticSearchException e) {
                if (e.unwrapCause() instanceof ConnectTransportException) continue;
                throw e;
            }
        }
        throw new NoNodeAvailableException();
    }

    public <Response> void execute(NodeListenerCallback<Response> callback, ActionListener<Response> listener) throws ElasticSearchException {
        ImmutableList<DiscoveryNode> nodes = this.nodes;
        if (nodes.isEmpty()) {
            throw new NoNodeAvailableException();
        }
        int index = this.randomNodeGenerator.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.randomNodeGenerator.set(0);
        }
        RetryListener<Response> retryListener = new RetryListener<Response>(callback, listener, nodes, index);
        try {
            callback.doWithNode((DiscoveryNode)nodes.get(index % nodes.size()), retryListener);
        }
        catch (ElasticSearchException e) {
            if (e.unwrapCause() instanceof ConnectTransportException) {
                retryListener.onFailure(e);
            }
            throw e;
        }
    }

    public void close() {
        this.closed = true;
        this.nodesSamplerFuture.cancel(true);
        for (DiscoveryNode node : this.nodes) {
            this.transportService.disconnectFromNode(node);
        }
        for (DiscoveryNode listedNode : this.listedNodes) {
            this.transportService.disconnectFromNode(listedNode);
        }
        this.nodes = ImmutableList.of();
    }

    public static interface NodeListenerCallback<Response> {
        public void doWithNode(DiscoveryNode var1, ActionListener<Response> var2) throws ElasticSearchException;
    }

    public static interface NodeCallback<T> {
        public T doWithNode(DiscoveryNode var1) throws ElasticSearchException;
    }

    class SniffNodesSampler
    implements NodeSampler {
        SniffNodesSampler() {
        }

        @Override
        public synchronized void sample() {
            if (TransportClientNodesService.this.closed) {
                return;
            }
            HashSet<DiscoveryNode> nodesToPing = Sets.newHashSet();
            for (DiscoveryNode node : TransportClientNodesService.this.listedNodes) {
                nodesToPing.add(node);
            }
            for (DiscoveryNode node : TransportClientNodesService.this.nodes) {
                nodesToPing.add(node);
            }
            final CountDownLatch latch = new CountDownLatch(nodesToPing.size());
            final Queue<ClusterStateResponse> clusterStateResponses = ConcurrentCollections.newQueue();
            for (final DiscoveryNode listedNode : nodesToPing) {
                TransportClientNodesService.this.threadPool.executor("management").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!TransportClientNodesService.this.transportService.nodeConnected(listedNode)) {
                                try {
                                    if (TransportClientNodesService.this.nodes.contains(listedNode)) {
                                        TransportClientNodesService.this.logger.trace("connecting to cluster node [{}]", listedNode);
                                        TransportClientNodesService.this.transportService.connectToNode(listedNode);
                                    } else {
                                        TransportClientNodesService.this.logger.trace("connecting to listed node (light) [{}]", listedNode);
                                        TransportClientNodesService.this.transportService.connectToNodeLight(listedNode);
                                    }
                                }
                                catch (Exception e) {
                                    TransportClientNodesService.this.logger.debug("failed to connect to node [{}], ignoring...", e, listedNode);
                                    latch.countDown();
                                    return;
                                }
                            }
                            TransportClientNodesService.this.transportService.sendRequest(listedNode, "cluster/state", Requests.clusterStateRequest().filterAll().filterNodes(false).local(true), TransportRequestOptions.options().withHighType().withTimeout(TransportClientNodesService.this.pingTimeout), new BaseTransportResponseHandler<ClusterStateResponse>(){

                                @Override
                                public ClusterStateResponse newInstance() {
                                    return new ClusterStateResponse();
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public void handleResponse(ClusterStateResponse response) {
                                    clusterStateResponses.add(response);
                                    latch.countDown();
                                }

                                @Override
                                public void handleException(TransportException e) {
                                    TransportClientNodesService.this.logger.info("failed to get local cluster state for {}, disconnecting...", e, listedNode);
                                    TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                                    latch.countDown();
                                }
                            });
                        }
                        catch (Exception e) {
                            TransportClientNodesService.this.logger.info("failed to get local cluster state info for {}, disconnecting...", e, listedNode);
                            TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                return;
            }
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            for (ClusterStateResponse clusterStateResponse : clusterStateResponses) {
                if (!TransportClientNodesService.this.ignoreClusterName && !TransportClientNodesService.this.clusterName.equals(clusterStateResponse.clusterName())) {
                    TransportClientNodesService.this.logger.warn("node {} not part of the cluster {}, ignoring...", clusterStateResponse.state().nodes().localNode(), TransportClientNodesService.this.clusterName);
                }
                for (DiscoveryNode node : clusterStateResponse.state().nodes().dataNodes().values()) {
                    newNodes.add(node);
                }
            }
            Iterator it = newNodes.iterator();
            while (it.hasNext()) {
                DiscoveryNode node = (DiscoveryNode)it.next();
                if (TransportClientNodesService.this.transportService.nodeConnected(node)) continue;
                try {
                    TransportClientNodesService.this.logger.trace("connecting to node [{}]", node);
                    TransportClientNodesService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    it.remove();
                    TransportClientNodesService.this.logger.debug("failed to connect to discovered node [" + node + "]", e, new Object[0]);
                }
            }
            TransportClientNodesService.this.nodes = (ImmutableList)((ImmutableList.Builder)new ImmutableList.Builder().addAll(newNodes)).build();
        }
    }

    class SimpleNodeSampler
    implements NodeSampler {
        SimpleNodeSampler() {
        }

        @Override
        public synchronized void sample() {
            if (TransportClientNodesService.this.closed) {
                return;
            }
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            for (DiscoveryNode node : TransportClientNodesService.this.listedNodes) {
                if (!TransportClientNodesService.this.transportService.nodeConnected(node)) {
                    try {
                        TransportClientNodesService.this.transportService.connectToNode(node);
                    }
                    catch (Exception e) {
                        TransportClientNodesService.this.logger.debug("failed to connect to node [{}], removed from nodes list", e, node);
                        continue;
                    }
                }
                try {
                    NodesInfoResponse nodeInfo = TransportClientNodesService.this.transportService.submitRequest(node, "cluster/nodes/info", Requests.nodesInfoRequest("_local"), TransportRequestOptions.options().withHighType().withTimeout(TransportClientNodesService.this.pingTimeout), new FutureTransportResponseHandler<NodesInfoResponse>(){

                        @Override
                        public NodesInfoResponse newInstance() {
                            return new NodesInfoResponse();
                        }
                    }).txGet();
                    if (!TransportClientNodesService.this.ignoreClusterName && !TransportClientNodesService.this.clusterName.equals(nodeInfo.clusterName())) {
                        TransportClientNodesService.this.logger.warn("node {} not part of the cluster {}, ignoring...", node, TransportClientNodesService.this.clusterName);
                        continue;
                    }
                    newNodes.add(node);
                }
                catch (Exception e) {
                    TransportClientNodesService.this.logger.info("failed to get node info for {}, disconnecting...", e, node);
                    TransportClientNodesService.this.transportService.disconnectFromNode(node);
                }
            }
            TransportClientNodesService.this.nodes = (ImmutableList)((ImmutableList.Builder)new ImmutableList.Builder().addAll(newNodes)).build();
        }
    }

    class ScheduledNodeSampler
    implements Runnable {
        ScheduledNodeSampler() {
        }

        @Override
        public void run() {
            try {
                TransportClientNodesService.this.nodesSampler.sample();
                if (!TransportClientNodesService.this.closed) {
                    TransportClientNodesService.this.nodesSamplerFuture = TransportClientNodesService.this.threadPool.schedule(TransportClientNodesService.this.nodesSamplerInterval, "generic", this);
                }
            }
            catch (Exception e) {
                TransportClientNodesService.this.logger.warn("failed to sample", e, new Object[0]);
            }
        }
    }

    static interface NodeSampler {
        public void sample();
    }

    public static class RetryListener<Response>
    implements ActionListener<Response> {
        private final NodeListenerCallback<Response> callback;
        private final ActionListener<Response> listener;
        private final ImmutableList<DiscoveryNode> nodes;
        private final int index;
        private volatile int i;

        public RetryListener(NodeListenerCallback<Response> callback, ActionListener<Response> listener, ImmutableList<DiscoveryNode> nodes, int index) {
            this.callback = callback;
            this.listener = listener;
            this.nodes = nodes;
            this.index = index;
        }

        @Override
        public void onResponse(Response response) {
            this.listener.onResponse(response);
        }

        @Override
        public void onFailure(Throwable e) {
            if (ExceptionsHelper.unwrapCause(e) instanceof ConnectTransportException) {
                int i;
                if ((i = ++this.i) == this.nodes.size()) {
                    this.listener.onFailure(new NoNodeAvailableException());
                } else {
                    try {
                        this.callback.doWithNode((DiscoveryNode)this.nodes.get((this.index + i) % this.nodes.size()), this);
                    }
                    catch (Exception e1) {
                        this.onFailure(e);
                    }
                }
            } else {
                this.listener.onFailure(e);
            }
        }
    }
}

