/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.util.CharsetUtil;

public class ByteBufferBytesReference
implements BytesReference {
    private final ByteBuffer buffer;

    public ByteBufferBytesReference(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(this.buffer.position() + index);
    }

    @Override
    public int length() {
        return this.buffer.remaining();
    }

    @Override
    public BytesReference slice(int from, int length) {
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(this.buffer.position() + from);
        dup.limit(this.buffer.position() + from + length);
        return new ByteBufferBytesReference(dup);
    }

    @Override
    public StreamInput streamInput() {
        return new ByteBufferStreamInput(this.buffer);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.buffer.hasArray()) {
            os.write(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        } else {
            byte[] tmp = new byte[8192];
            ByteBuffer buf = this.buffer.duplicate();
            while (buf.hasRemaining()) {
                buf.get(tmp, 0, Math.min(tmp.length, buf.remaining()));
                os.write(tmp);
            }
        }
    }

    @Override
    public byte[] toBytes() {
        if (!this.buffer.hasRemaining()) {
            return Bytes.EMPTY_ARRAY;
        }
        byte[] tmp = new byte[this.buffer.remaining()];
        this.buffer.duplicate().get(tmp);
        return tmp;
    }

    @Override
    public BytesArray toBytesArray() {
        if (this.buffer.hasArray()) {
            return new BytesArray(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        }
        return new BytesArray(this.toBytes());
    }

    @Override
    public BytesArray copyBytesArray() {
        return new BytesArray(this.toBytes());
    }

    @Override
    public ChannelBuffer toChannelBuffer() {
        return ChannelBuffers.wrappedBuffer(this.buffer);
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.buffer.position();
    }

    @Override
    public String toUtf8() {
        if (!this.buffer.hasRemaining()) {
            return "";
        }
        CharsetDecoder decoder = CharsetUtil.getDecoder(Charsets.UTF_8);
        CharBuffer dst = CharBuffer.allocate((int)((double)this.buffer.remaining() * (double)decoder.maxCharsPerByte()));
        try {
            CoderResult cr = decoder.decode(this.buffer, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return dst.flip().toString();
    }
}

