/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.lucene.search.NoCacheFilter;

public class LimitFilter
extends NoCacheFilter {
    private final int limit;
    private int counter;

    public LimitFilter(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.counter > this.limit) {
            return null;
        }
        return new LimitDocSet(reader.maxDoc(), this.limit);
    }

    public class LimitDocSet
    extends GetDocSet {
        private final int limit;

        public LimitDocSet(int maxDoc, int limit) {
            super(maxDoc);
            this.limit = limit;
        }

        @Override
        public boolean get(int doc) {
            return ++LimitFilter.this.counter <= this.limit;
        }
    }
}

