/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreManagement;
import org.elasticsearch.jmx.JmxService;

public class StoreModule
extends AbstractModule {
    private final Settings settings;
    private final IndexStore indexStore;

    public StoreModule(Settings settings, IndexStore indexStore) {
        this.indexStore = indexStore;
        this.settings = settings;
    }

    @Override
    protected void configure() {
        this.bind(DirectoryService.class).to(this.indexStore.shardDirectory()).asEagerSingleton();
        this.bind(Store.class).asEagerSingleton();
        if (JmxService.shouldExport(this.settings)) {
            this.bind(StoreManagement.class).asEagerSingleton();
        }
    }
}

