/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.XMMapFSDirectory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.fs.FsDirectoryService;

public class MmapFsDirectoryService
extends FsDirectoryService {
    @Inject
    public MmapFsDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore) {
        super(shardId, indexSettings, indexStore);
    }

    @Override
    public Directory[] build() throws IOException {
        File[] locations = this.indexStore.shardIndexLocations(this.shardId);
        Directory[] dirs = new Directory[locations.length];
        for (int i = 0; i < dirs.length; ++i) {
            FileSystemUtils.mkdirs(locations[i]);
            dirs[i] = new XMMapFSDirectory(locations[i], this.buildLockFactory(), this, this);
        }
        return dirs;
    }
}

