/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.unbounded;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.unbounded.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueScriptHistogramFacetCollector
extends AbstractFacetCollector {
    private final String indexFieldName;
    private final HistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType fieldDataType;
    private NumericFieldData fieldData;
    private final SearchScript valueScript;
    private final HistogramProc histoProc;

    public ValueScriptHistogramFacetCollector(String facetName, String fieldName, String scriptLang, String valueScript, Map<String, Object> params, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.explicitTypeInNameWithDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        FieldMapper mapper = smartMappers.mapper();
        this.indexFieldName = mapper.names().indexName();
        this.fieldDataType = mapper.fieldDataType();
        this.histoProc = new HistogramProc(interval, this.valueScript);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.histoProc);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.valueScript.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (NumericFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        this.valueScript.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        return new InternalFullHistogramFacet(this.facetName, this.comparatorType, this.histoProc.entries, true);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }

    public static class HistogramProc
    implements NumericFieldData.DoubleValueInDocProc {
        private final long interval;
        private final SearchScript valueScript;
        final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries = CacheRecycler.popLongObjectMap();

        public HistogramProc(long interval, SearchScript valueScript) {
            this.interval = interval;
            this.valueScript = valueScript;
        }

        @Override
        public void onValue(int docId, double value) {
            this.valueScript.setNextDocId(docId);
            long bucket = ValueScriptHistogramFacetCollector.bucket(value, this.interval);
            double scriptValue = this.valueScript.runAsDouble();
            InternalFullHistogramFacet.FullEntry entry = (InternalFullHistogramFacet.FullEntry)this.entries.get(bucket);
            if (entry == null) {
                entry = new InternalFullHistogramFacet.FullEntry(bucket, 1L, scriptValue, scriptValue, 1L, scriptValue);
                this.entries.put(bucket, entry);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += scriptValue;
                if (scriptValue < entry.min) {
                    entry.min = scriptValue;
                }
                if (scriptValue > entry.max) {
                    entry.max = scriptValue;
                }
            }
        }
    }
}

