/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.facet.FacetPhase;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.FilterBinaryParseElement;
import org.elasticsearch.search.query.FilterParseElement;
import org.elasticsearch.search.query.FromParseElement;
import org.elasticsearch.search.query.IndicesBoostParseElement;
import org.elasticsearch.search.query.MinScoreParseElement;
import org.elasticsearch.search.query.QueryBinaryParseElement;
import org.elasticsearch.search.query.QueryParseElement;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.SizeParseElement;
import org.elasticsearch.search.query.TimeoutParseElement;
import org.elasticsearch.search.sort.SortParseElement;
import org.elasticsearch.search.sort.TrackScoresParseElement;

public class QueryPhase
implements SearchPhase {
    private final FacetPhase facetPhase;

    @Inject
    public QueryPhase(FacetPhase facetPhase) {
        this.facetPhase = facetPhase;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, FromParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("from", new FromParseElement()).put("size", (FromParseElement)((Object)new SizeParseElement())).put("indices_boost", (FromParseElement)((Object)new IndicesBoostParseElement())).put("indicesBoost", (FromParseElement)((Object)new IndicesBoostParseElement())).put("query", (FromParseElement)((Object)new QueryParseElement())).put("queryBinary", (FromParseElement)((Object)new QueryBinaryParseElement())).put("query_binary", (FromParseElement)((Object)new QueryBinaryParseElement())).put("filter", (FromParseElement)((Object)new FilterParseElement())).put("filterBinary", (FromParseElement)((Object)new FilterBinaryParseElement())).put("filter_binary", (FromParseElement)((Object)new FilterBinaryParseElement())).put("sort", (FromParseElement)((Object)new SortParseElement())).put("trackScores", (FromParseElement)((Object)new TrackScoresParseElement())).put("track_scores", (FromParseElement)((Object)new TrackScoresParseElement())).put("min_score", (FromParseElement)((Object)new MinScoreParseElement())).put("minScore", (FromParseElement)((Object)new MinScoreParseElement())).put("timeout", (FromParseElement)((Object)new TimeoutParseElement())).putAll(this.facetPhase.parseElements());
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
        context.preProcess();
        this.facetPhase.preProcess(context);
    }

    @Override
    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        searchContext.queryResult().searchTimedOut(false);
        if (searchContext.scopePhases() != null) {
            try {
                searchContext.idCache().refresh(searchContext.searcher().subReaders());
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(searchContext, "Failed to refresh id cache for child queries", (Throwable)e);
            }
            block11: for (ScopePhase scopePhase : searchContext.scopePhases()) {
                if (scopePhase instanceof ScopePhase.TopDocsPhase) {
                    ScopePhase.TopDocsPhase topDocsPhase = (ScopePhase.TopDocsPhase)scopePhase;
                    int numDocs = searchContext.from() + searchContext.size();
                    if (numDocs == 0) {
                        numDocs = 1;
                    }
                    try {
                        numDocs *= topDocsPhase.factor();
                        while (true) {
                            topDocsPhase.clear();
                            if (topDocsPhase.scope() != null) {
                                searchContext.searcher().processingScope(topDocsPhase.scope());
                            }
                            TopDocs topDocs = searchContext.searcher().search(topDocsPhase.query(), numDocs);
                            if (topDocsPhase.scope() != null) {
                                searchContext.searcher().processedScope();
                            }
                            topDocsPhase.processResults(topDocs, searchContext);
                            if (topDocsPhase.numHits() >= searchContext.from() + searchContext.size() || topDocs.totalHits <= numDocs) continue block11;
                            if ((numDocs *= topDocsPhase.incrementalFactor()) <= topDocs.totalHits) continue;
                            numDocs = topDocs.totalHits;
                        }
                    }
                    catch (Exception e) {
                        throw new QueryPhaseExecutionException(searchContext, "Failed to execute child query [" + scopePhase.query() + "]", (Throwable)e);
                    }
                }
                if (!(scopePhase instanceof ScopePhase.CollectorPhase)) continue;
                try {
                    ScopePhase.CollectorPhase collectorPhase = (ScopePhase.CollectorPhase)scopePhase;
                    if (!collectorPhase.requiresProcessing()) continue;
                    if (scopePhase.scope() != null) {
                        searchContext.searcher().processingScope(scopePhase.scope());
                    }
                    Collector collector = collectorPhase.collector();
                    searchContext.searcher().search(collectorPhase.query(), collector);
                    collectorPhase.processCollector(collector);
                    if (collectorPhase.scope() == null) continue;
                    searchContext.searcher().processedScope();
                }
                catch (Exception e) {
                    throw new QueryPhaseExecutionException(searchContext, "Failed to execute child query [" + scopePhase.query() + "]", (Throwable)e);
                }
            }
        }
        searchContext.searcher().processingScope("_main_");
        try {
            TopDocs topDocs;
            searchContext.queryResult().from(searchContext.from());
            searchContext.queryResult().size(searchContext.size());
            Query query = searchContext.query();
            int numDocs = searchContext.from() + searchContext.size();
            if (numDocs == 0) {
                numDocs = 1;
            }
            if (searchContext.searchType() == SearchType.COUNT) {
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searchContext.searcher().search(query, collector);
                topDocs = new TopDocs(collector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
            } else {
                topDocs = searchContext.searchType() == SearchType.SCAN ? searchContext.scanContext().execute(searchContext) : (searchContext.sort() != null ? searchContext.searcher().search(query, null, numDocs, searchContext.sort()) : searchContext.searcher().search(query, numDocs));
            }
            searchContext.queryResult().topDocs(topDocs);
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(searchContext, "Failed to execute main query", (Throwable)e);
        }
        finally {
            searchContext.searcher().processedScope();
        }
        this.facetPhase.execute(searchContext);
    }
}

